package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{SourceURI, Name, Arn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataIntegrationSummary(
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    sourceURI: Optional[SourceURI] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.DataIntegrationSummary = {
    import DataIntegrationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.DataIntegrationSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        sourceURI.map(value => SourceURI.unwrap(value): java.lang.String)
      )(_.sourceURI)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly =
    zio.aws.appintegrations.model.DataIntegrationSummary.wrap(buildAwsValue())
}
object DataIntegrationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.DataIntegrationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.DataIntegrationSummary =
      zio.aws.appintegrations.model.DataIntegrationSummary(
        arn.map(value => value),
        name.map(value => value),
        sourceURI.map(value => value)
      )
    def arn: Optional[Arn]
    def name: Optional[Name]
    def sourceURI: Optional[SourceURI]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSourceURI: ZIO[Any, AwsError, SourceURI] =
      AwsError.unwrapOptionField("sourceURI", sourceURI)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.DataIntegrationSummary
  ) extends zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appintegrations.model.primitives.Name(value))
    override val sourceURI: Optional[SourceURI] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceURI())
      .map(value => zio.aws.appintegrations.model.primitives.SourceURI(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.DataIntegrationSummary
  ): zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly =
    new Wrapper(impl)
}
