package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appintegrations.model.primitives.Name
import scala.jdk.CollectionConverters._
final case class GetEventIntegrationRequest(name: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationRequest = {
    import GetEventIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.GetEventIntegrationRequest.ReadOnly =
    zio.aws.appintegrations.model.GetEventIntegrationRequest
      .wrap(buildAwsValue())
}
object GetEventIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.GetEventIntegrationRequest =
      zio.aws.appintegrations.model.GetEventIntegrationRequest(name)
    def name: Name
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationRequest
  ) extends zio.aws.appintegrations.model.GetEventIntegrationRequest.ReadOnly {
    override val name: Name =
      zio.aws.appintegrations.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationRequest
  ): zio.aws.appintegrations.model.GetEventIntegrationRequest.ReadOnly =
    new Wrapper(impl)
}
