package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListEventIntegrationsResponse(
    eventIntegrations: Option[
      Iterable[zio.aws.appintegrations.model.EventIntegration]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse = {
    import ListEventIntegrationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse
      .builder()
      .optionallyWith(
        eventIntegrations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventIntegrations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.ListEventIntegrationsResponse.ReadOnly =
    zio.aws.appintegrations.model.ListEventIntegrationsResponse
      .wrap(buildAwsValue())
}
object ListEventIntegrationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.ListEventIntegrationsResponse =
      zio.aws.appintegrations.model.ListEventIntegrationsResponse(
        eventIntegrations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eventIntegrations
        : Option[List[zio.aws.appintegrations.model.EventIntegration.ReadOnly]]
    def nextToken: Option[NextToken]
    def getEventIntegrations: ZIO[Any, AwsError, List[
      zio.aws.appintegrations.model.EventIntegration.ReadOnly
    ]] = AwsError.unwrapOptionField("eventIntegrations", eventIntegrations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse
  ) extends zio.aws.appintegrations.model.ListEventIntegrationsResponse.ReadOnly {
    override val eventIntegrations: Option[
      List[zio.aws.appintegrations.model.EventIntegration.ReadOnly]
    ] = scala
      .Option(impl.eventIntegrations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appintegrations.model.EventIntegration.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appintegrations.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse
  ): zio.aws.appintegrations.model.ListEventIntegrationsResponse.ReadOnly =
    new Wrapper(impl)
}
