package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  Schedule,
  Object,
  NonBlankString
}
import scala.jdk.CollectionConverters._
final case class ScheduleConfiguration(
    firstExecutionFrom: Option[NonBlankString] = None,
    `object`: Option[Object] = None,
    scheduleExpression: Option[Schedule] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration = {
    import ScheduleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration
      .builder()
      .optionallyWith(
        firstExecutionFrom.map(value =>
          NonBlankString.unwrap(value): java.lang.String
        )
      )(_.firstExecutionFrom)
      .optionallyWith(
        `object`.map(value => Object.unwrap(value): java.lang.String)
      )(_.`object`)
      .optionallyWith(
        scheduleExpression.map(value =>
          Schedule.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .build()
  }
  def asReadOnly: zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly =
    zio.aws.appintegrations.model.ScheduleConfiguration.wrap(buildAwsValue())
}
object ScheduleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.ScheduleConfiguration =
      zio.aws.appintegrations.model.ScheduleConfiguration(
        firstExecutionFrom.map(value => value),
        `object`.map(value => value),
        scheduleExpression.map(value => value)
      )
    def firstExecutionFrom: Option[NonBlankString]
    def `object`: Option[Object]
    def scheduleExpression: Option[Schedule]
    def getFirstExecutionFrom: ZIO[Any, AwsError, NonBlankString] =
      AwsError.unwrapOptionField("firstExecutionFrom", firstExecutionFrom)
    def getObject: ZIO[Any, AwsError, Object] =
      AwsError.unwrapOptionField("object", `object`)
    def getScheduleExpression: ZIO[Any, AwsError, Schedule] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration
  ) extends zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly {
    override val firstExecutionFrom: Option[NonBlankString] = scala
      .Option(impl.firstExecutionFrom())
      .map(value =>
        zio.aws.appintegrations.model.primitives.NonBlankString(value)
      )
    override val `object`: Option[Object] = scala
      .Option(impl.`object`())
      .map(value => zio.aws.appintegrations.model.primitives.Object(value))
    override val scheduleExpression: Option[Schedule] = scala
      .Option(impl.scheduleExpression())
      .map(value => zio.aws.appintegrations.model.primitives.Schedule(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration
  ): zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
