package zio.aws.appconfigdata.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.appconfigdata.model.primitives.{OptionalPollSeconds, Identifier}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StartConfigurationSessionRequest(
    applicationIdentifier: Identifier,
    environmentIdentifier: Identifier,
    configurationProfileIdentifier: Identifier,
    requiredMinimumPollIntervalInSeconds: Optional[OptionalPollSeconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionRequest = {
    import StartConfigurationSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionRequest
      .builder()
      .applicationIdentifier(
        Identifier.unwrap(applicationIdentifier): java.lang.String
      )
      .environmentIdentifier(
        Identifier.unwrap(environmentIdentifier): java.lang.String
      )
      .configurationProfileIdentifier(
        Identifier.unwrap(configurationProfileIdentifier): java.lang.String
      )
      .optionallyWith(
        requiredMinimumPollIntervalInSeconds.map(value =>
          OptionalPollSeconds.unwrap(value): Integer
        )
      )(_.requiredMinimumPollIntervalInSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfigdata.model.StartConfigurationSessionRequest.ReadOnly =
    zio.aws.appconfigdata.model.StartConfigurationSessionRequest
      .wrap(buildAwsValue())
}
object StartConfigurationSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appconfigdata.model.StartConfigurationSessionRequest =
      zio.aws.appconfigdata.model.StartConfigurationSessionRequest(
        applicationIdentifier,
        environmentIdentifier,
        configurationProfileIdentifier,
        requiredMinimumPollIntervalInSeconds.map(value => value)
      )
    def applicationIdentifier: Identifier
    def environmentIdentifier: Identifier
    def configurationProfileIdentifier: Identifier
    def requiredMinimumPollIntervalInSeconds: Optional[OptionalPollSeconds]
    def getApplicationIdentifier: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(applicationIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(environmentIdentifier)
    def getConfigurationProfileIdentifier: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(configurationProfileIdentifier)
    def getRequiredMinimumPollIntervalInSeconds
        : ZIO[Any, AwsError, OptionalPollSeconds] = AwsError.unwrapOptionField(
      "requiredMinimumPollIntervalInSeconds",
      requiredMinimumPollIntervalInSeconds
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionRequest
  ) extends zio.aws.appconfigdata.model.StartConfigurationSessionRequest.ReadOnly {
    override val applicationIdentifier: Identifier =
      zio.aws.appconfigdata.model.primitives
        .Identifier(impl.applicationIdentifier())
    override val environmentIdentifier: Identifier =
      zio.aws.appconfigdata.model.primitives
        .Identifier(impl.environmentIdentifier())
    override val configurationProfileIdentifier: Identifier =
      zio.aws.appconfigdata.model.primitives
        .Identifier(impl.configurationProfileIdentifier())
    override val requiredMinimumPollIntervalInSeconds
        : Optional[OptionalPollSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.requiredMinimumPollIntervalInSeconds())
      .map(value =>
        zio.aws.appconfigdata.model.primitives.OptionalPollSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionRequest
  ): zio.aws.appconfigdata.model.StartConfigurationSessionRequest.ReadOnly =
    new Wrapper(impl)
}
