package zio.aws.appconfigdata
import zio.mock.{Proxy, Mock}
import zio.aws.appconfigdata.model.{
  StartConfigurationSessionRequest,
  GetLatestConfigurationRequest
}
import zio.aws.appconfigdata.model.StartConfigurationSessionResponse.ReadOnly
import software.amazon.awssdk.services.appconfigdata.AppConfigDataAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
object AppConfigDataMock extends Mock[AppConfigData] {
  object GetLatestConfiguration
      extends Effect[
        GetLatestConfigurationRequest,
        AwsError,
        zio.aws.appconfigdata.model.GetLatestConfigurationResponse.ReadOnly
      ]
  object StartConfigurationSession
      extends Effect[StartConfigurationSessionRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, AppConfigData] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, AppConfigData] { rts =>
        zio.ZIO.succeed {
          new AppConfigData {
            val api: AppConfigDataAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): AppConfigData = this
            def getLatestConfiguration(
                request: GetLatestConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.appconfigdata.model.GetLatestConfigurationResponse.ReadOnly
            ] = proxy(GetLatestConfiguration, request)
            def startConfigurationSession(
                request: StartConfigurationSessionRequest
            ): IO[AwsError, ReadOnly] =
              proxy(StartConfigurationSession, request)
          }
        }
      }
    }
  }
}
