package zio.aws.appconfigdata.model
import zio.aws.appconfigdata.model.primitives.{
  SyntheticGetLatestConfigurationResponseBlob,
  Integer,
  Token
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLatestConfigurationResponse(
    nextPollConfigurationToken: Option[Token] = None,
    nextPollIntervalInSeconds: Option[Integer] = None,
    contentType: Option[String] = None,
    configuration: Option[SyntheticGetLatestConfigurationResponseBlob] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse = {
    import GetLatestConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse
      .builder()
      .optionallyWith(
        nextPollConfigurationToken.map(value =>
          Token.unwrap(value): java.lang.String
        )
      )(_.nextPollConfigurationToken)
      .optionallyWith(
        nextPollIntervalInSeconds.map(value => value: java.lang.Integer)
      )(_.nextPollIntervalInSeconds)
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .optionallyWith(
        configuration.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.configuration)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfigdata.model.GetLatestConfigurationResponse.ReadOnly =
    zio.aws.appconfigdata.model.GetLatestConfigurationResponse
      .wrap(buildAwsValue())
}
object GetLatestConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfigdata.model.GetLatestConfigurationResponse =
      zio.aws.appconfigdata.model.GetLatestConfigurationResponse(
        nextPollConfigurationToken.map(value => value),
        nextPollIntervalInSeconds.map(value => value),
        contentType.map(value => value),
        configuration.map(value => value)
      )
    def nextPollConfigurationToken: Option[Token]
    def nextPollIntervalInSeconds: Option[Integer]
    def contentType: Option[String]
    def configuration: Option[SyntheticGetLatestConfigurationResponseBlob]
    def getNextPollConfigurationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField(
        "nextPollConfigurationToken",
        nextPollConfigurationToken
      )
    def getNextPollIntervalInSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("nextPollIntervalInSeconds", nextPollIntervalInSeconds)
    def getContentType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getConfiguration
        : ZIO[Any, AwsError, SyntheticGetLatestConfigurationResponseBlob] =
      AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse
  ) extends zio.aws.appconfigdata.model.GetLatestConfigurationResponse.ReadOnly {
    override val nextPollConfigurationToken: Option[Token] = scala
      .Option(impl.nextPollConfigurationToken())
      .map(value => zio.aws.appconfigdata.model.primitives.Token(value))
    override val nextPollIntervalInSeconds: Option[Integer] = scala
      .Option(impl.nextPollIntervalInSeconds())
      .map(value => value: Integer)
    override val contentType: Option[String] =
      scala.Option(impl.contentType()).map(value => value: String)
    override val configuration
        : Option[SyntheticGetLatestConfigurationResponseBlob] = scala
      .Option(impl.configuration())
      .map(value =>
        zio.aws.appconfigdata.model.primitives
          .SyntheticGetLatestConfigurationResponseBlob(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse
  ): zio.aws.appconfigdata.model.GetLatestConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
