package zio.aws.appconfigdata
import zio.aws.core.config.AwsConfig
import zio.aws.appconfigdata.model.{
  StartConfigurationSessionRequest,
  GetLatestConfigurationRequest
}
import zio.aws.appconfigdata.model.StartConfigurationSessionResponse.ReadOnly
import software.amazon.awssdk.services.appconfigdata.{
  AppConfigDataAsyncClientBuilder,
  AppConfigDataAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.appconfigdata.model.{
  StartConfigurationSessionResponse,
  GetLatestConfigurationResponse
}
import scala.jdk.CollectionConverters.*
trait AppConfigData extends AspectSupport[AppConfigData] {
  val api: AppConfigDataAsyncClient
  def getLatestConfiguration(request: GetLatestConfigurationRequest): IO[
    AwsError,
    zio.aws.appconfigdata.model.GetLatestConfigurationResponse.ReadOnly
  ]
  def startConfigurationSession(
      request: StartConfigurationSessionRequest
  ): IO[AwsError, ReadOnly]
}
object AppConfigData {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AppConfigData] = customized(
    identity
  )
  def customized(
      customization: AppConfigDataAsyncClientBuilder => AppConfigDataAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AppConfigData] = managed(
    customization
  ).toLayer
  def managed(
      customization: AppConfigDataAsyncClientBuilder => AppConfigDataAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, AppConfigData] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = AppConfigDataAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[AppConfigDataAsyncClient, AppConfigDataAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        AppConfigDataAsyncClient,
        AppConfigDataAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new AppConfigDataImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class AppConfigDataImpl[R](
      override val api: AppConfigDataAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AppConfigData
      with AwsServiceBase[R] {
    override val serviceName: String = "AppConfigData"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AppConfigDataImpl[R1] = new AppConfigDataImpl(api, newAspect, r)
    def getLatestConfiguration(request: GetLatestConfigurationRequest): IO[
      AwsError,
      zio.aws.appconfigdata.model.GetLatestConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationRequest,
      GetLatestConfigurationResponse
    ]("getLatestConfiguration", api.getLatestConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.appconfigdata.model.GetLatestConfigurationResponse.wrap)
      .provideEnvironment(r)
    def startConfigurationSession(
        request: StartConfigurationSessionRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionRequest,
      StartConfigurationSessionResponse
    ]("startConfigurationSession", api.startConfigurationSession)(
      request.buildAwsValue()
    ).map(zio.aws.appconfigdata.model.StartConfigurationSessionResponse.wrap)
      .provideEnvironment(r)
  }
  def getLatestConfiguration(request: GetLatestConfigurationRequest): ZIO[
    zio.aws.appconfigdata.AppConfigData,
    AwsError,
    zio.aws.appconfigdata.model.GetLatestConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLatestConfiguration(request))
  def startConfigurationSession(
      request: StartConfigurationSessionRequest
  ): ZIO[zio.aws.appconfigdata.AppConfigData, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.startConfigurationSession(request))
}
