package zio.aws.appconfigdata.model
import zio.aws.appconfigdata.model.primitives.{
  Integer,
  Token,
  SyntheticGetLatestConfigurationResponseBlob
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLatestConfigurationResponse(
    configuration: Option[SyntheticGetLatestConfigurationResponseBlob] = None,
    contentType: Option[String] = None,
    nextPollConfigurationToken: Option[Token] = None,
    nextPollIntervalInSeconds: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse = {
    import GetLatestConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse
      .builder()
      .optionallyWith(
        configuration.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.configuration)
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .optionallyWith(
        nextPollConfigurationToken.map(value =>
          Token.unwrap(value): java.lang.String
        )
      )(_.nextPollConfigurationToken)
      .optionallyWith(
        nextPollIntervalInSeconds.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.nextPollIntervalInSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfigdata.model.GetLatestConfigurationResponse.ReadOnly =
    zio.aws.appconfigdata.model.GetLatestConfigurationResponse
      .wrap(buildAwsValue())
}
object GetLatestConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfigdata.model.GetLatestConfigurationResponse =
      zio.aws.appconfigdata.model.GetLatestConfigurationResponse(
        configuration.map(value => value),
        contentType.map(value => value),
        nextPollConfigurationToken.map(value => value),
        nextPollIntervalInSeconds.map(value => value)
      )
    def configuration: Option[SyntheticGetLatestConfigurationResponseBlob]
    def contentType: Option[String]
    def nextPollConfigurationToken: Option[Token]
    def nextPollIntervalInSeconds: Option[Integer]
    def getConfiguration
        : ZIO[Any, AwsError, SyntheticGetLatestConfigurationResponseBlob] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getContentType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getNextPollConfigurationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField(
        "nextPollConfigurationToken",
        nextPollConfigurationToken
      )
    def getNextPollIntervalInSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("nextPollIntervalInSeconds", nextPollIntervalInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse
  ) extends zio.aws.appconfigdata.model.GetLatestConfigurationResponse.ReadOnly {
    override val configuration
        : Option[SyntheticGetLatestConfigurationResponseBlob] = scala
      .Option(impl.configuration())
      .map(value =>
        zio.aws.appconfigdata.model.primitives
          .SyntheticGetLatestConfigurationResponseBlob(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
      )
    override val contentType: Option[String] =
      scala.Option(impl.contentType()).map(value => value: String)
    override val nextPollConfigurationToken: Option[Token] = scala
      .Option(impl.nextPollConfigurationToken())
      .map(value => zio.aws.appconfigdata.model.primitives.Token(value))
    override val nextPollIntervalInSeconds: Option[Integer] = scala
      .Option(impl.nextPollIntervalInSeconds())
      .map(value => zio.aws.appconfigdata.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse
  ): zio.aws.appconfigdata.model.GetLatestConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
