package zio.aws.appconfigdata.model
import zio.aws.appconfigdata.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartConfigurationSessionResponse(
    initialConfigurationToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionResponse = {
    import StartConfigurationSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionResponse
      .builder()
      .optionallyWith(
        initialConfigurationToken.map(value =>
          Token.unwrap(value): java.lang.String
        )
      )(_.initialConfigurationToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfigdata.model.StartConfigurationSessionResponse.ReadOnly =
    zio.aws.appconfigdata.model.StartConfigurationSessionResponse
      .wrap(buildAwsValue())
}
object StartConfigurationSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appconfigdata.model.StartConfigurationSessionResponse =
      zio.aws.appconfigdata.model.StartConfigurationSessionResponse(
        initialConfigurationToken.map(value => value)
      )
    def initialConfigurationToken: Option[Token]
    def getInitialConfigurationToken: ZIO[Any, AwsError, Token] = AwsError
      .unwrapOptionField("initialConfigurationToken", initialConfigurationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionResponse
  ) extends zio.aws.appconfigdata.model.StartConfigurationSessionResponse.ReadOnly {
    override val initialConfigurationToken: Option[Token] = scala
      .Option(impl.initialConfigurationToken())
      .map(value => zio.aws.appconfigdata.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionResponse
  ): zio.aws.appconfigdata.model.StartConfigurationSessionResponse.ReadOnly =
    new Wrapper(impl)
}
