package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  StringWithLengthBetween1And64,
  UriWithLengthBetween1And2048
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MutualTlsAuthentication(
    truststoreUri: Optional[UriWithLengthBetween1And2048] = Optional.Absent,
    truststoreVersion: Optional[StringWithLengthBetween1And64] =
      Optional.Absent,
    truststoreWarnings: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthentication = {
    import MutualTlsAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthentication
      .builder()
      .optionallyWith(
        truststoreUri.map(value =>
          UriWithLengthBetween1And2048.unwrap(value): java.lang.String
        )
      )(_.truststoreUri)
      .optionallyWith(
        truststoreVersion.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.truststoreVersion)
      .optionallyWith(
        truststoreWarnings.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.truststoreWarnings)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.MutualTlsAuthentication.ReadOnly =
    zio.aws.apigatewayv2.model.MutualTlsAuthentication.wrap(buildAwsValue())
}
object MutualTlsAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.MutualTlsAuthentication =
      zio.aws.apigatewayv2.model.MutualTlsAuthentication(
        truststoreUri.map(value => value),
        truststoreVersion.map(value => value),
        truststoreWarnings.map(value => value)
      )
    def truststoreUri: Optional[UriWithLengthBetween1And2048]
    def truststoreVersion: Optional[StringWithLengthBetween1And64]
    def truststoreWarnings: Optional[List[__string]]
    def getTruststoreUri: ZIO[Any, AwsError, UriWithLengthBetween1And2048] =
      AwsError.unwrapOptionField("truststoreUri", truststoreUri)
    def getTruststoreVersion
        : ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("truststoreVersion", truststoreVersion)
    def getTruststoreWarnings: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("truststoreWarnings", truststoreWarnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthentication
  ) extends zio.aws.apigatewayv2.model.MutualTlsAuthentication.ReadOnly {
    override val truststoreUri: Optional[UriWithLengthBetween1And2048] =
      zio.aws.core.internal
        .optionalFromNullable(impl.truststoreUri())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .UriWithLengthBetween1And2048(value)
        )
    override val truststoreVersion: Optional[StringWithLengthBetween1And64] =
      zio.aws.core.internal
        .optionalFromNullable(impl.truststoreVersion())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And64(value)
        )
    override val truststoreWarnings: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.truststoreWarnings())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthentication
  ): zio.aws.apigatewayv2.model.MutualTlsAuthentication.ReadOnly = new Wrapper(
    impl
  )
}
