package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  StringWithLengthBetween1And128
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVpcLinkRequest(
    name: Optional[StringWithLengthBetween1And128] = Optional.Absent,
    vpcLinkId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest = {
    import UpdateVpcLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest
      .builder()
      .optionallyWith(
        name.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.name)
      .vpcLinkId(vpcLinkId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateVpcLinkRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateVpcLinkRequest.wrap(buildAwsValue())
}
object UpdateVpcLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateVpcLinkRequest =
      zio.aws.apigatewayv2.model
        .UpdateVpcLinkRequest(name.map(value => value), vpcLinkId)
    def name: Optional[StringWithLengthBetween1And128]
    def vpcLinkId: __string
    def getName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("name", name)
    def getVpcLinkId: ZIO[Any, Nothing, __string] = ZIO.succeed(vpcLinkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest
  ) extends zio.aws.apigatewayv2.model.UpdateVpcLinkRequest.ReadOnly {
    override val name: Optional[StringWithLengthBetween1And128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And128(value)
        )
    override val vpcLinkId: __string = impl.vpcLinkId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest
  ): zio.aws.apigatewayv2.model.UpdateVpcLinkRequest.ReadOnly = new Wrapper(
    impl
  )
}
