package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And128,
  SelectionKey,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ApiMapping(
    apiId: Id,
    apiMappingId: Optional[Id] = Optional.Absent,
    apiMappingKey: Optional[SelectionKey] = Optional.Absent,
    stage: StringWithLengthBetween1And128
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.ApiMapping = {
    import ApiMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.ApiMapping
      .builder()
      .apiId(Id.unwrap(apiId): java.lang.String)
      .optionallyWith(
        apiMappingId.map(value => Id.unwrap(value): java.lang.String)
      )(_.apiMappingId)
      .optionallyWith(
        apiMappingKey.map(value => SelectionKey.unwrap(value): java.lang.String)
      )(_.apiMappingKey)
      .stage(StringWithLengthBetween1And128.unwrap(stage): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.ApiMapping.ReadOnly =
    zio.aws.apigatewayv2.model.ApiMapping.wrap(buildAwsValue())
}
object ApiMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.ApiMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.ApiMapping =
      zio.aws.apigatewayv2.model.ApiMapping(
        apiId,
        apiMappingId.map(value => value),
        apiMappingKey.map(value => value),
        stage
      )
    def apiId: Id
    def apiMappingId: Optional[Id]
    def apiMappingKey: Optional[SelectionKey]
    def stage: StringWithLengthBetween1And128
    def getApiId: ZIO[Any, Nothing, Id] = ZIO.succeed(apiId)
    def getApiMappingId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("apiMappingId", apiMappingId)
    def getApiMappingKey: ZIO[Any, AwsError, SelectionKey] =
      AwsError.unwrapOptionField("apiMappingKey", apiMappingKey)
    def getStage: ZIO[Any, Nothing, StringWithLengthBetween1And128] =
      ZIO.succeed(stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ApiMapping
  ) extends zio.aws.apigatewayv2.model.ApiMapping.ReadOnly {
    override val apiId: Id =
      zio.aws.apigatewayv2.model.primitives.Id(impl.apiId())
    override val apiMappingId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.apiMappingId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val apiMappingKey: Optional[SelectionKey] = zio.aws.core.internal
      .optionalFromNullable(impl.apiMappingKey())
      .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
    override val stage: StringWithLengthBetween1And128 =
      zio.aws.apigatewayv2.model.primitives
        .StringWithLengthBetween1And128(impl.stage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ApiMapping
  ): zio.aws.apigatewayv2.model.ApiMapping.ReadOnly = new Wrapper(impl)
}
