package zio.aws.apigatewayv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  __boolean,
  Arn,
  UriWithLengthBetween1And2048,
  StringWithLengthBetween1And64,
  StringWithLengthBetween0And1024,
  SelectionExpression,
  StringWithLengthBetween1And1024,
  StringWithLengthBetween1And512,
  StringWithLengthBetween0And32K,
  StringWithLengthBetween1And128,
  Id,
  IntegerWithLengthBetween50And30000
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetIntegrationResponse(
    apiGatewayManaged: Optional[__boolean] = Optional.Absent,
    connectionId: Optional[StringWithLengthBetween1And1024] = Optional.Absent,
    connectionType: Optional[zio.aws.apigatewayv2.model.ConnectionType] =
      Optional.Absent,
    contentHandlingStrategy: Optional[
      zio.aws.apigatewayv2.model.ContentHandlingStrategy
    ] = Optional.Absent,
    credentialsArn: Optional[Arn] = Optional.Absent,
    description: Optional[StringWithLengthBetween0And1024] = Optional.Absent,
    integrationId: Optional[Id] = Optional.Absent,
    integrationMethod: Optional[StringWithLengthBetween1And64] =
      Optional.Absent,
    integrationResponseSelectionExpression: Optional[SelectionExpression] =
      Optional.Absent,
    integrationSubtype: Optional[StringWithLengthBetween1And128] =
      Optional.Absent,
    integrationType: Optional[zio.aws.apigatewayv2.model.IntegrationType] =
      Optional.Absent,
    integrationUri: Optional[UriWithLengthBetween1And2048] = Optional.Absent,
    passthroughBehavior: Optional[
      zio.aws.apigatewayv2.model.PassthroughBehavior
    ] = Optional.Absent,
    payloadFormatVersion: Optional[StringWithLengthBetween1And64] =
      Optional.Absent,
    requestParameters: Optional[Map[__string, StringWithLengthBetween1And512]] =
      Optional.Absent,
    requestTemplates: Optional[Map[__string, StringWithLengthBetween0And32K]] =
      Optional.Absent,
    responseParameters: Optional[
      Map[__string, Map[__string, StringWithLengthBetween1And512]]
    ] = Optional.Absent,
    templateSelectionExpression: Optional[SelectionExpression] =
      Optional.Absent,
    timeoutInMillis: Optional[IntegerWithLengthBetween50And30000] =
      Optional.Absent,
    tlsConfig: Optional[zio.aws.apigatewayv2.model.TlsConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse = {
    import GetIntegrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse
      .builder()
      .optionallyWith(apiGatewayManaged.map(value => value: java.lang.Boolean))(
        _.apiGatewayManaged
      )
      .optionallyWith(
        connectionId.map(value =>
          StringWithLengthBetween1And1024.unwrap(value): java.lang.String
        )
      )(_.connectionId)
      .optionallyWith(connectionType.map(value => value.unwrap))(
        _.connectionType
      )
      .optionallyWith(contentHandlingStrategy.map(value => value.unwrap))(
        _.contentHandlingStrategy
      )
      .optionallyWith(
        credentialsArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.credentialsArn)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        integrationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.integrationId)
      .optionallyWith(
        integrationMethod.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.integrationMethod)
      .optionallyWith(
        integrationResponseSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.integrationResponseSelectionExpression)
      .optionallyWith(
        integrationSubtype.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.integrationSubtype)
      .optionallyWith(integrationType.map(value => value.unwrap))(
        _.integrationType
      )
      .optionallyWith(
        integrationUri.map(value =>
          UriWithLengthBetween1And2048.unwrap(value): java.lang.String
        )
      )(_.integrationUri)
      .optionallyWith(passthroughBehavior.map(value => value.unwrap))(
        _.passthroughBehavior
      )
      .optionallyWith(
        payloadFormatVersion.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.payloadFormatVersion)
      .optionallyWith(
        requestParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And512.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.requestParameters)
      .optionallyWith(
        requestTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween0And32K.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.requestTemplates)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> (StringWithLengthBetween1And512
                    .unwrap(value): java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        templateSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.templateSelectionExpression)
      .optionallyWith(
        timeoutInMillis.map(value =>
          IntegerWithLengthBetween50And30000.unwrap(value): Integer
        )
      )(_.timeoutInMillis)
      .optionallyWith(tlsConfig.map(value => value.buildAwsValue()))(
        _.tlsConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetIntegrationResponse.ReadOnly =
    zio.aws.apigatewayv2.model.GetIntegrationResponse.wrap(buildAwsValue())
}
object GetIntegrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetIntegrationResponse =
      zio.aws.apigatewayv2.model.GetIntegrationResponse(
        apiGatewayManaged.map(value => value),
        connectionId.map(value => value),
        connectionType.map(value => value),
        contentHandlingStrategy.map(value => value),
        credentialsArn.map(value => value),
        description.map(value => value),
        integrationId.map(value => value),
        integrationMethod.map(value => value),
        integrationResponseSelectionExpression.map(value => value),
        integrationSubtype.map(value => value),
        integrationType.map(value => value),
        integrationUri.map(value => value),
        passthroughBehavior.map(value => value),
        payloadFormatVersion.map(value => value),
        requestParameters.map(value => value),
        requestTemplates.map(value => value),
        responseParameters.map(value => value),
        templateSelectionExpression.map(value => value),
        timeoutInMillis.map(value => value),
        tlsConfig.map(value => value.asEditable)
      )
    def apiGatewayManaged: Optional[__boolean]
    def connectionId: Optional[StringWithLengthBetween1And1024]
    def connectionType: Optional[zio.aws.apigatewayv2.model.ConnectionType]
    def contentHandlingStrategy
        : Optional[zio.aws.apigatewayv2.model.ContentHandlingStrategy]
    def credentialsArn: Optional[Arn]
    def description: Optional[StringWithLengthBetween0And1024]
    def integrationId: Optional[Id]
    def integrationMethod: Optional[StringWithLengthBetween1And64]
    def integrationResponseSelectionExpression: Optional[SelectionExpression]
    def integrationSubtype: Optional[StringWithLengthBetween1And128]
    def integrationType: Optional[zio.aws.apigatewayv2.model.IntegrationType]
    def integrationUri: Optional[UriWithLengthBetween1And2048]
    def passthroughBehavior
        : Optional[zio.aws.apigatewayv2.model.PassthroughBehavior]
    def payloadFormatVersion: Optional[StringWithLengthBetween1And64]
    def requestParameters
        : Optional[Map[__string, StringWithLengthBetween1And512]]
    def requestTemplates
        : Optional[Map[__string, StringWithLengthBetween0And32K]]
    def responseParameters
        : Optional[Map[__string, Map[__string, StringWithLengthBetween1And512]]]
    def templateSelectionExpression: Optional[SelectionExpression]
    def timeoutInMillis: Optional[IntegerWithLengthBetween50And30000]
    def tlsConfig: Optional[zio.aws.apigatewayv2.model.TlsConfig.ReadOnly]
    def getApiGatewayManaged: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("apiGatewayManaged", apiGatewayManaged)
    def getConnectionId: ZIO[Any, AwsError, StringWithLengthBetween1And1024] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getConnectionType
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.ConnectionType] =
      AwsError.unwrapOptionField("connectionType", connectionType)
    def getContentHandlingStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.ContentHandlingStrategy
    ] = AwsError.unwrapOptionField(
      "contentHandlingStrategy",
      contentHandlingStrategy
    )
    def getCredentialsArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("credentialsArn", credentialsArn)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getIntegrationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("integrationId", integrationId)
    def getIntegrationMethod
        : ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("integrationMethod", integrationMethod)
    def getIntegrationResponseSelectionExpression
        : ZIO[Any, AwsError, SelectionExpression] = AwsError.unwrapOptionField(
      "integrationResponseSelectionExpression",
      integrationResponseSelectionExpression
    )
    def getIntegrationSubtype
        : ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("integrationSubtype", integrationSubtype)
    def getIntegrationType
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.IntegrationType] =
      AwsError.unwrapOptionField("integrationType", integrationType)
    def getIntegrationUri: ZIO[Any, AwsError, UriWithLengthBetween1And2048] =
      AwsError.unwrapOptionField("integrationUri", integrationUri)
    def getPassthroughBehavior
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.PassthroughBehavior] =
      AwsError.unwrapOptionField("passthroughBehavior", passthroughBehavior)
    def getPayloadFormatVersion
        : ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("payloadFormatVersion", payloadFormatVersion)
    def getRequestParameters
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And512]] =
      AwsError.unwrapOptionField("requestParameters", requestParameters)
    def getRequestTemplates
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween0And32K]] =
      AwsError.unwrapOptionField("requestTemplates", requestTemplates)
    def getResponseParameters: ZIO[Any, AwsError, Map[
      __string,
      Map[__string, StringWithLengthBetween1And512]
    ]] = AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getTemplateSelectionExpression
        : ZIO[Any, AwsError, SelectionExpression] = AwsError.unwrapOptionField(
      "templateSelectionExpression",
      templateSelectionExpression
    )
    def getTimeoutInMillis
        : ZIO[Any, AwsError, IntegerWithLengthBetween50And30000] =
      AwsError.unwrapOptionField("timeoutInMillis", timeoutInMillis)
    def getTlsConfig
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.TlsConfig.ReadOnly] =
      AwsError.unwrapOptionField("tlsConfig", tlsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse
  ) extends zio.aws.apigatewayv2.model.GetIntegrationResponse.ReadOnly {
    override val apiGatewayManaged: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.apiGatewayManaged())
      .map(value => value: __boolean)
    override val connectionId: Optional[StringWithLengthBetween1And1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionId())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And1024(value)
        )
    override val connectionType
        : Optional[zio.aws.apigatewayv2.model.ConnectionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionType())
        .map(value => zio.aws.apigatewayv2.model.ConnectionType.wrap(value))
    override val contentHandlingStrategy
        : Optional[zio.aws.apigatewayv2.model.ContentHandlingStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentHandlingStrategy())
        .map(value =>
          zio.aws.apigatewayv2.model.ContentHandlingStrategy.wrap(value)
        )
    override val credentialsArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.credentialsArn())
      .map(value => zio.aws.apigatewayv2.model.primitives.Arn(value))
    override val description: Optional[StringWithLengthBetween0And1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween0And1024(value)
        )
    override val integrationId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.integrationId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val integrationMethod: Optional[StringWithLengthBetween1And64] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationMethod())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And64(value)
        )
    override val integrationResponseSelectionExpression
        : Optional[SelectionExpression] = zio.aws.core.internal
      .optionalFromNullable(impl.integrationResponseSelectionExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
      )
    override val integrationSubtype: Optional[StringWithLengthBetween1And128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationSubtype())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And128(value)
        )
    override val integrationType
        : Optional[zio.aws.apigatewayv2.model.IntegrationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationType())
        .map(value => zio.aws.apigatewayv2.model.IntegrationType.wrap(value))
    override val integrationUri: Optional[UriWithLengthBetween1And2048] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationUri())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .UriWithLengthBetween1And2048(value)
        )
    override val passthroughBehavior
        : Optional[zio.aws.apigatewayv2.model.PassthroughBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.passthroughBehavior())
        .map(value =>
          zio.aws.apigatewayv2.model.PassthroughBehavior.wrap(value)
        )
    override val payloadFormatVersion: Optional[StringWithLengthBetween1And64] =
      zio.aws.core.internal
        .optionalFromNullable(impl.payloadFormatVersion())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And64(value)
        )
    override val requestParameters
        : Optional[Map[__string, StringWithLengthBetween1And512]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And512(value)
            })
            .toMap
        )
    override val requestTemplates
        : Optional[Map[__string, StringWithLengthBetween0And32K]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestTemplates())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween0And32K(value)
            })
            .toMap
        )
    override val responseParameters: Optional[
      Map[__string, Map[__string, StringWithLengthBetween1And512]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.responseParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> value.asScala
              .map({ case (key, value) =>
                (key: __string) -> zio.aws.apigatewayv2.model.primitives
                  .StringWithLengthBetween1And512(value)
              })
              .toMap
          })
          .toMap
      )
    override val templateSelectionExpression: Optional[SelectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
    override val timeoutInMillis: Optional[IntegerWithLengthBetween50And30000] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutInMillis())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .IntegerWithLengthBetween50And30000(value)
        )
    override val tlsConfig
        : Optional[zio.aws.apigatewayv2.model.TlsConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsConfig())
        .map(value => zio.aws.apigatewayv2.model.TlsConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse
  ): zio.aws.apigatewayv2.model.GetIntegrationResponse.ReadOnly = new Wrapper(
    impl
  )
}
