package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDomainNamesRequest(
    maxResults: Optional[__string] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest = {
    import GetDomainNamesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: java.lang.String))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetDomainNamesRequest.ReadOnly =
    zio.aws.apigatewayv2.model.GetDomainNamesRequest.wrap(buildAwsValue())
}
object GetDomainNamesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetDomainNamesRequest =
      zio.aws.apigatewayv2.model.GetDomainNamesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[__string]
    def nextToken: Optional[__string]
    def getMaxResults: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest
  ) extends zio.aws.apigatewayv2.model.GetDomainNamesRequest.ReadOnly {
    override val maxResults: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: __string)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest
  ): zio.aws.apigatewayv2.model.GetDomainNamesRequest.ReadOnly = new Wrapper(
    impl
  )
}
