package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  SelectionKey,
  StringWithLengthBetween1And128,
  SelectionExpression,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateRouteResponseRequest(
    apiId: __string,
    modelSelectionExpression: Optional[SelectionExpression] = Optional.Absent,
    responseModels: Optional[Map[__string, StringWithLengthBetween1And128]] =
      Optional.Absent,
    responseParameters: Optional[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints]
    ] = Optional.Absent,
    routeId: __string,
    routeResponseId: __string,
    routeResponseKey: Optional[SelectionKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest = {
    import UpdateRouteResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(
        modelSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.modelSelectionExpression)
      .optionallyWith(
        responseModels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And128.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.responseModels)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.responseParameters)
      .routeId(routeId: java.lang.String)
      .routeResponseId(routeResponseId: java.lang.String)
      .optionallyWith(
        routeResponseKey.map(value =>
          SelectionKey.unwrap(value): java.lang.String
        )
      )(_.routeResponseKey)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewayv2.model.UpdateRouteResponseRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateRouteResponseRequest.wrap(buildAwsValue())
}
object UpdateRouteResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateRouteResponseRequest =
      zio.aws.apigatewayv2.model.UpdateRouteResponseRequest(
        apiId,
        modelSelectionExpression.map(value => value),
        responseModels.map(value => value),
        responseParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        routeId,
        routeResponseId,
        routeResponseKey.map(value => value)
      )
    def apiId: __string
    def modelSelectionExpression: Optional[SelectionExpression]
    def responseModels: Optional[Map[__string, StringWithLengthBetween1And128]]
    def responseParameters: Optional[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ]
    def routeId: __string
    def routeResponseId: __string
    def routeResponseKey: Optional[SelectionKey]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getModelSelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "modelSelectionExpression",
        modelSelectionExpression
      )
    def getResponseModels
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And128]] =
      AwsError.unwrapOptionField("responseModels", responseModels)
    def getResponseParameters: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly
    ]] = AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getRouteId: ZIO[Any, Nothing, __string] = ZIO.succeed(routeId)
    def getRouteResponseId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(routeResponseId)
    def getRouteResponseKey: ZIO[Any, AwsError, SelectionKey] =
      AwsError.unwrapOptionField("routeResponseKey", routeResponseKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest
  ) extends zio.aws.apigatewayv2.model.UpdateRouteResponseRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val modelSelectionExpression: Optional[SelectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
    override val responseModels
        : Optional[Map[__string, StringWithLengthBetween1And128]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseModels())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And128(value)
            })
            .toMap
        )
    override val responseParameters: Optional[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.responseParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.ParameterConstraints
              .wrap(value)
          })
          .toMap
      )
    override val routeId: __string = impl.routeId(): __string
    override val routeResponseId: __string = impl.routeResponseId(): __string
    override val routeResponseKey: Optional[SelectionKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeResponseKey())
        .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest
  ): zio.aws.apigatewayv2.model.UpdateRouteResponseRequest.ReadOnly =
    new Wrapper(impl)
}
