package zio.aws.apigatewayv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigatewayv2.model.primitives.{__double, __integer, __boolean}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RouteSettings(
    dataTraceEnabled: Optional[__boolean] = Optional.Absent,
    detailedMetricsEnabled: Optional[__boolean] = Optional.Absent,
    loggingLevel: Optional[zio.aws.apigatewayv2.model.LoggingLevel] =
      Optional.Absent,
    throttlingBurstLimit: Optional[__integer] = Optional.Absent,
    throttlingRateLimit: Optional[__double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.RouteSettings = {
    import RouteSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.RouteSettings
      .builder()
      .optionallyWith(dataTraceEnabled.map(value => value: java.lang.Boolean))(
        _.dataTraceEnabled
      )
      .optionallyWith(
        detailedMetricsEnabled.map(value => value: java.lang.Boolean)
      )(_.detailedMetricsEnabled)
      .optionallyWith(loggingLevel.map(value => value.unwrap))(_.loggingLevel)
      .optionallyWith(throttlingBurstLimit.map(value => value: Integer))(
        _.throttlingBurstLimit
      )
      .optionallyWith(
        throttlingRateLimit.map(value => value: java.lang.Double)
      )(_.throttlingRateLimit)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.RouteSettings.ReadOnly =
    zio.aws.apigatewayv2.model.RouteSettings.wrap(buildAwsValue())
}
object RouteSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.RouteSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.RouteSettings =
      zio.aws.apigatewayv2.model.RouteSettings(
        dataTraceEnabled.map(value => value),
        detailedMetricsEnabled.map(value => value),
        loggingLevel.map(value => value),
        throttlingBurstLimit.map(value => value),
        throttlingRateLimit.map(value => value)
      )
    def dataTraceEnabled: Optional[__boolean]
    def detailedMetricsEnabled: Optional[__boolean]
    def loggingLevel: Optional[zio.aws.apigatewayv2.model.LoggingLevel]
    def throttlingBurstLimit: Optional[__integer]
    def throttlingRateLimit: Optional[__double]
    def getDataTraceEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("dataTraceEnabled", dataTraceEnabled)
    def getDetailedMetricsEnabled: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("detailedMetricsEnabled", detailedMetricsEnabled)
    def getLoggingLevel
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.LoggingLevel] =
      AwsError.unwrapOptionField("loggingLevel", loggingLevel)
    def getThrottlingBurstLimit: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("throttlingBurstLimit", throttlingBurstLimit)
    def getThrottlingRateLimit: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("throttlingRateLimit", throttlingRateLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.RouteSettings
  ) extends zio.aws.apigatewayv2.model.RouteSettings.ReadOnly {
    override val dataTraceEnabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dataTraceEnabled())
      .map(value => value: __boolean)
    override val detailedMetricsEnabled: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detailedMetricsEnabled())
        .map(value => value: __boolean)
    override val loggingLevel
        : Optional[zio.aws.apigatewayv2.model.LoggingLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingLevel())
        .map(value => zio.aws.apigatewayv2.model.LoggingLevel.wrap(value))
    override val throttlingBurstLimit: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throttlingBurstLimit())
        .map(value => value: __integer)
    override val throttlingRateLimit: Optional[__double] = zio.aws.core.internal
      .optionalFromNullable(impl.throttlingRateLimit())
      .map(value => value: __double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.RouteSettings
  ): zio.aws.apigatewayv2.model.RouteSettings.ReadOnly = new Wrapper(impl)
}
