package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And128,
  SelectionKey,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateApiMappingResponse(
    apiId: Optional[Id] = Optional.Absent,
    apiMappingId: Optional[Id] = Optional.Absent,
    apiMappingKey: Optional[SelectionKey] = Optional.Absent,
    stage: Optional[StringWithLengthBetween1And128] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingResponse = {
    import UpdateApiMappingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingResponse
      .builder()
      .optionallyWith(apiId.map(value => Id.unwrap(value): java.lang.String))(
        _.apiId
      )
      .optionallyWith(
        apiMappingId.map(value => Id.unwrap(value): java.lang.String)
      )(_.apiMappingId)
      .optionallyWith(
        apiMappingKey.map(value => SelectionKey.unwrap(value): java.lang.String)
      )(_.apiMappingKey)
      .optionallyWith(
        stage.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateApiMappingResponse.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateApiMappingResponse.wrap(buildAwsValue())
}
object UpdateApiMappingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateApiMappingResponse =
      zio.aws.apigatewayv2.model.UpdateApiMappingResponse(
        apiId.map(value => value),
        apiMappingId.map(value => value),
        apiMappingKey.map(value => value),
        stage.map(value => value)
      )
    def apiId: Optional[Id]
    def apiMappingId: Optional[Id]
    def apiMappingKey: Optional[SelectionKey]
    def stage: Optional[StringWithLengthBetween1And128]
    def getApiId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getApiMappingId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("apiMappingId", apiMappingId)
    def getApiMappingKey: ZIO[Any, AwsError, SelectionKey] =
      AwsError.unwrapOptionField("apiMappingKey", apiMappingKey)
    def getStage: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingResponse
  ) extends zio.aws.apigatewayv2.model.UpdateApiMappingResponse.ReadOnly {
    override val apiId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.apiId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val apiMappingId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.apiMappingId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val apiMappingKey: Optional[SelectionKey] = zio.aws.core.internal
      .optionalFromNullable(impl.apiMappingKey())
      .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
    override val stage: Optional[StringWithLengthBetween1And128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stage())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And128(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingResponse
  ): zio.aws.apigatewayv2.model.UpdateApiMappingResponse.ReadOnly = new Wrapper(
    impl
  )
}
