package zio.aws.apigatewayv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigatewayv2.model.primitives.{
  IntegerWithLengthBetween0And3600,
  __string,
  __boolean,
  Arn,
  UriWithLengthBetween1And2048,
  StringWithLengthBetween1And64,
  StringWithLengthBetween0And1024,
  StringWithLengthBetween1And128,
  Id
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateAuthorizerResponse(
    authorizerCredentialsArn: Optional[Arn] = Optional.Absent,
    authorizerId: Optional[Id] = Optional.Absent,
    authorizerPayloadFormatVersion: Optional[StringWithLengthBetween1And64] =
      Optional.Absent,
    authorizerResultTtlInSeconds: Optional[IntegerWithLengthBetween0And3600] =
      Optional.Absent,
    authorizerType: Optional[zio.aws.apigatewayv2.model.AuthorizerType] =
      Optional.Absent,
    authorizerUri: Optional[UriWithLengthBetween1And2048] = Optional.Absent,
    enableSimpleResponses: Optional[__boolean] = Optional.Absent,
    identitySource: Optional[Iterable[__string]] = Optional.Absent,
    identityValidationExpression: Optional[StringWithLengthBetween0And1024] =
      Optional.Absent,
    jwtConfiguration: Optional[zio.aws.apigatewayv2.model.JWTConfiguration] =
      Optional.Absent,
    name: Optional[StringWithLengthBetween1And128] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse = {
    import CreateAuthorizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse
      .builder()
      .optionallyWith(
        authorizerCredentialsArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.authorizerCredentialsArn)
      .optionallyWith(
        authorizerId.map(value => Id.unwrap(value): java.lang.String)
      )(_.authorizerId)
      .optionallyWith(
        authorizerPayloadFormatVersion.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.authorizerPayloadFormatVersion)
      .optionallyWith(
        authorizerResultTtlInSeconds.map(value =>
          IntegerWithLengthBetween0And3600.unwrap(value): Integer
        )
      )(_.authorizerResultTtlInSeconds)
      .optionallyWith(authorizerType.map(value => value.unwrap))(
        _.authorizerType
      )
      .optionallyWith(
        authorizerUri.map(value =>
          UriWithLengthBetween1And2048.unwrap(value): java.lang.String
        )
      )(_.authorizerUri)
      .optionallyWith(
        enableSimpleResponses.map(value => value: java.lang.Boolean)
      )(_.enableSimpleResponses)
      .optionallyWith(
        identitySource.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.identitySource)
      .optionallyWith(
        identityValidationExpression.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.identityValidationExpression)
      .optionallyWith(jwtConfiguration.map(value => value.buildAwsValue()))(
        _.jwtConfiguration
      )
      .optionallyWith(
        name.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateAuthorizerResponse.ReadOnly =
    zio.aws.apigatewayv2.model.CreateAuthorizerResponse.wrap(buildAwsValue())
}
object CreateAuthorizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateAuthorizerResponse =
      zio.aws.apigatewayv2.model.CreateAuthorizerResponse(
        authorizerCredentialsArn.map(value => value),
        authorizerId.map(value => value),
        authorizerPayloadFormatVersion.map(value => value),
        authorizerResultTtlInSeconds.map(value => value),
        authorizerType.map(value => value),
        authorizerUri.map(value => value),
        enableSimpleResponses.map(value => value),
        identitySource.map(value => value),
        identityValidationExpression.map(value => value),
        jwtConfiguration.map(value => value.asEditable),
        name.map(value => value)
      )
    def authorizerCredentialsArn: Optional[Arn]
    def authorizerId: Optional[Id]
    def authorizerPayloadFormatVersion: Optional[StringWithLengthBetween1And64]
    def authorizerResultTtlInSeconds: Optional[IntegerWithLengthBetween0And3600]
    def authorizerType: Optional[zio.aws.apigatewayv2.model.AuthorizerType]
    def authorizerUri: Optional[UriWithLengthBetween1And2048]
    def enableSimpleResponses: Optional[__boolean]
    def identitySource: Optional[List[__string]]
    def identityValidationExpression: Optional[StringWithLengthBetween0And1024]
    def jwtConfiguration
        : Optional[zio.aws.apigatewayv2.model.JWTConfiguration.ReadOnly]
    def name: Optional[StringWithLengthBetween1And128]
    def getAuthorizerCredentialsArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("authorizerCredentialsArn", authorizerCredentialsArn)
    def getAuthorizerId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("authorizerId", authorizerId)
    def getAuthorizerPayloadFormatVersion
        : ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField(
        "authorizerPayloadFormatVersion",
        authorizerPayloadFormatVersion
      )
    def getAuthorizerResultTtlInSeconds
        : ZIO[Any, AwsError, IntegerWithLengthBetween0And3600] =
      AwsError.unwrapOptionField(
        "authorizerResultTtlInSeconds",
        authorizerResultTtlInSeconds
      )
    def getAuthorizerType
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.AuthorizerType] =
      AwsError.unwrapOptionField("authorizerType", authorizerType)
    def getAuthorizerUri: ZIO[Any, AwsError, UriWithLengthBetween1And2048] =
      AwsError.unwrapOptionField("authorizerUri", authorizerUri)
    def getEnableSimpleResponses: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enableSimpleResponses", enableSimpleResponses)
    def getIdentitySource: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("identitySource", identitySource)
    def getIdentityValidationExpression
        : ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField(
        "identityValidationExpression",
        identityValidationExpression
      )
    def getJwtConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.JWTConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("jwtConfiguration", jwtConfiguration)
    def getName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse
  ) extends zio.aws.apigatewayv2.model.CreateAuthorizerResponse.ReadOnly {
    override val authorizerCredentialsArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizerCredentialsArn())
      .map(value => zio.aws.apigatewayv2.model.primitives.Arn(value))
    override val authorizerId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizerId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val authorizerPayloadFormatVersion
        : Optional[StringWithLengthBetween1And64] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizerPayloadFormatVersion())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And64(value)
      )
    override val authorizerResultTtlInSeconds
        : Optional[IntegerWithLengthBetween0And3600] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizerResultTtlInSeconds())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .IntegerWithLengthBetween0And3600(value)
      )
    override val authorizerType
        : Optional[zio.aws.apigatewayv2.model.AuthorizerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizerType())
        .map(value => zio.aws.apigatewayv2.model.AuthorizerType.wrap(value))
    override val authorizerUri: Optional[UriWithLengthBetween1And2048] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizerUri())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .UriWithLengthBetween1And2048(value)
        )
    override val enableSimpleResponses: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableSimpleResponses())
        .map(value => value: __boolean)
    override val identitySource: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identitySource())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val identityValidationExpression
        : Optional[StringWithLengthBetween0And1024] = zio.aws.core.internal
      .optionalFromNullable(impl.identityValidationExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween0And1024(value)
      )
    override val jwtConfiguration
        : Optional[zio.aws.apigatewayv2.model.JWTConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jwtConfiguration())
        .map(value => zio.aws.apigatewayv2.model.JWTConfiguration.wrap(value))
    override val name: Optional[StringWithLengthBetween1And128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And128(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse
  ): zio.aws.apigatewayv2.model.CreateAuthorizerResponse.ReadOnly = new Wrapper(
    impl
  )
}
