package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetApiMappingsResponse(
    items: Optional[Iterable[zio.aws.apigatewayv2.model.ApiMapping]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsResponse = {
    import GetApiMappingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetApiMappingsResponse.ReadOnly =
    zio.aws.apigatewayv2.model.GetApiMappingsResponse.wrap(buildAwsValue())
}
object GetApiMappingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetApiMappingsResponse =
      zio.aws.apigatewayv2.model.GetApiMappingsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.apigatewayv2.model.ApiMapping.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.apigatewayv2.model.ApiMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsResponse
  ) extends zio.aws.apigatewayv2.model.GetApiMappingsResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.apigatewayv2.model.ApiMapping.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigatewayv2.model.ApiMapping.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.apigatewayv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsResponse
  ): zio.aws.apigatewayv2.model.GetApiMappingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
