package zio.aws.apigatewayv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigatewayv2.model.primitives.{
  __timestampIso8601,
  StringWithLengthBetween1And128,
  Arn,
  __string
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DomainNameConfiguration(
    apiGatewayDomainName: Optional[__string] = Optional.Absent,
    certificateArn: Optional[Arn] = Optional.Absent,
    certificateName: Optional[StringWithLengthBetween1And128] = Optional.Absent,
    certificateUploadDate: Optional[__timestampIso8601] = Optional.Absent,
    domainNameStatus: Optional[zio.aws.apigatewayv2.model.DomainNameStatus] =
      Optional.Absent,
    domainNameStatusMessage: Optional[__string] = Optional.Absent,
    endpointType: Optional[zio.aws.apigatewayv2.model.EndpointType] =
      Optional.Absent,
    hostedZoneId: Optional[__string] = Optional.Absent,
    securityPolicy: Optional[zio.aws.apigatewayv2.model.SecurityPolicy] =
      Optional.Absent,
    ownershipVerificationCertificateArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration = {
    import DomainNameConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration
      .builder()
      .optionallyWith(
        apiGatewayDomainName.map(value => value: java.lang.String)
      )(_.apiGatewayDomainName)
      .optionallyWith(
        certificateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .optionallyWith(
        certificateName.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.certificateName)
      .optionallyWith(certificateUploadDate.map(value => value: Instant))(
        _.certificateUploadDate
      )
      .optionallyWith(domainNameStatus.map(value => value.unwrap))(
        _.domainNameStatus
      )
      .optionallyWith(
        domainNameStatusMessage.map(value => value: java.lang.String)
      )(_.domainNameStatusMessage)
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(hostedZoneId.map(value => value: java.lang.String))(
        _.hostedZoneId
      )
      .optionallyWith(securityPolicy.map(value => value.unwrap))(
        _.securityPolicy
      )
      .optionallyWith(
        ownershipVerificationCertificateArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.ownershipVerificationCertificateArn)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly =
    zio.aws.apigatewayv2.model.DomainNameConfiguration.wrap(buildAwsValue())
}
object DomainNameConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.DomainNameConfiguration =
      zio.aws.apigatewayv2.model.DomainNameConfiguration(
        apiGatewayDomainName.map(value => value),
        certificateArn.map(value => value),
        certificateName.map(value => value),
        certificateUploadDate.map(value => value),
        domainNameStatus.map(value => value),
        domainNameStatusMessage.map(value => value),
        endpointType.map(value => value),
        hostedZoneId.map(value => value),
        securityPolicy.map(value => value),
        ownershipVerificationCertificateArn.map(value => value)
      )
    def apiGatewayDomainName: Optional[__string]
    def certificateArn: Optional[Arn]
    def certificateName: Optional[StringWithLengthBetween1And128]
    def certificateUploadDate: Optional[__timestampIso8601]
    def domainNameStatus: Optional[zio.aws.apigatewayv2.model.DomainNameStatus]
    def domainNameStatusMessage: Optional[__string]
    def endpointType: Optional[zio.aws.apigatewayv2.model.EndpointType]
    def hostedZoneId: Optional[__string]
    def securityPolicy: Optional[zio.aws.apigatewayv2.model.SecurityPolicy]
    def ownershipVerificationCertificateArn: Optional[Arn]
    def getApiGatewayDomainName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiGatewayDomainName", apiGatewayDomainName)
    def getCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getCertificateUploadDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("certificateUploadDate", certificateUploadDate)
    def getDomainNameStatus
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.DomainNameStatus] =
      AwsError.unwrapOptionField("domainNameStatus", domainNameStatus)
    def getDomainNameStatusMessage: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("domainNameStatusMessage", domainNameStatusMessage)
    def getEndpointType
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getHostedZoneId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getSecurityPolicy
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.SecurityPolicy] =
      AwsError.unwrapOptionField("securityPolicy", securityPolicy)
    def getOwnershipVerificationCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "ownershipVerificationCertificateArn",
        ownershipVerificationCertificateArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration
  ) extends zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly {
    override val apiGatewayDomainName: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiGatewayDomainName())
        .map(value => value: __string)
    override val certificateArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => zio.aws.apigatewayv2.model.primitives.Arn(value))
    override val certificateName: Optional[StringWithLengthBetween1And128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateName())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And128(value)
        )
    override val certificateUploadDate: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateUploadDate())
        .map(value => value: __timestampIso8601)
    override val domainNameStatus
        : Optional[zio.aws.apigatewayv2.model.DomainNameStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainNameStatus())
        .map(value => zio.aws.apigatewayv2.model.DomainNameStatus.wrap(value))
    override val domainNameStatusMessage: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainNameStatusMessage())
        .map(value => value: __string)
    override val endpointType
        : Optional[zio.aws.apigatewayv2.model.EndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointType())
        .map(value => zio.aws.apigatewayv2.model.EndpointType.wrap(value))
    override val hostedZoneId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneId())
      .map(value => value: __string)
    override val securityPolicy
        : Optional[zio.aws.apigatewayv2.model.SecurityPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityPolicy())
        .map(value => zio.aws.apigatewayv2.model.SecurityPolicy.wrap(value))
    override val ownershipVerificationCertificateArn: Optional[Arn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownershipVerificationCertificateArn())
        .map(value => zio.aws.apigatewayv2.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration
  ): zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
