package zio.aws.apigatewayv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween0And2048,
  StringWithLengthBetween1And1600,
  __string,
  __boolean,
  StringWithLengthBetween0And1024,
  __timestampIso8601,
  StringWithLengthBetween1And128,
  Id
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Stage(
    accessLogSettings: Optional[zio.aws.apigatewayv2.model.AccessLogSettings] =
      Optional.Absent,
    apiGatewayManaged: Optional[__boolean] = Optional.Absent,
    autoDeploy: Optional[__boolean] = Optional.Absent,
    clientCertificateId: Optional[Id] = Optional.Absent,
    createdDate: Optional[__timestampIso8601] = Optional.Absent,
    defaultRouteSettings: Optional[zio.aws.apigatewayv2.model.RouteSettings] =
      Optional.Absent,
    deploymentId: Optional[Id] = Optional.Absent,
    description: Optional[StringWithLengthBetween0And1024] = Optional.Absent,
    lastDeploymentStatusMessage: Optional[__string] = Optional.Absent,
    lastUpdatedDate: Optional[__timestampIso8601] = Optional.Absent,
    routeSettings: Optional[
      Map[__string, zio.aws.apigatewayv2.model.RouteSettings]
    ] = Optional.Absent,
    stageName: StringWithLengthBetween1And128,
    stageVariables: Optional[Map[__string, StringWithLengthBetween0And2048]] =
      Optional.Absent,
    tags: Optional[Map[__string, StringWithLengthBetween1And1600]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.Stage = {
    import Stage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.Stage
      .builder()
      .optionallyWith(accessLogSettings.map(value => value.buildAwsValue()))(
        _.accessLogSettings
      )
      .optionallyWith(apiGatewayManaged.map(value => value: java.lang.Boolean))(
        _.apiGatewayManaged
      )
      .optionallyWith(autoDeploy.map(value => value: java.lang.Boolean))(
        _.autoDeploy
      )
      .optionallyWith(
        clientCertificateId.map(value => Id.unwrap(value): java.lang.String)
      )(_.clientCertificateId)
      .optionallyWith(createdDate.map(value => value: Instant))(_.createdDate)
      .optionallyWith(defaultRouteSettings.map(value => value.buildAwsValue()))(
        _.defaultRouteSettings
      )
      .optionallyWith(
        deploymentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        lastDeploymentStatusMessage.map(value => value: java.lang.String)
      )(_.lastDeploymentStatusMessage)
      .optionallyWith(lastUpdatedDate.map(value => value: Instant))(
        _.lastUpdatedDate
      )
      .optionallyWith(
        routeSettings.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.routeSettings)
      .stageName(
        StringWithLengthBetween1And128.unwrap(stageName): java.lang.String
      )
      .optionallyWith(
        stageVariables.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween0And2048
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.stageVariables)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And1600
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.Stage.ReadOnly =
    zio.aws.apigatewayv2.model.Stage.wrap(buildAwsValue())
}
object Stage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.Stage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.Stage =
      zio.aws.apigatewayv2.model.Stage(
        accessLogSettings.map(value => value.asEditable),
        apiGatewayManaged.map(value => value),
        autoDeploy.map(value => value),
        clientCertificateId.map(value => value),
        createdDate.map(value => value),
        defaultRouteSettings.map(value => value.asEditable),
        deploymentId.map(value => value),
        description.map(value => value),
        lastDeploymentStatusMessage.map(value => value),
        lastUpdatedDate.map(value => value),
        routeSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        stageName,
        stageVariables.map(value => value),
        tags.map(value => value)
      )
    def accessLogSettings
        : Optional[zio.aws.apigatewayv2.model.AccessLogSettings.ReadOnly]
    def apiGatewayManaged: Optional[__boolean]
    def autoDeploy: Optional[__boolean]
    def clientCertificateId: Optional[Id]
    def createdDate: Optional[__timestampIso8601]
    def defaultRouteSettings
        : Optional[zio.aws.apigatewayv2.model.RouteSettings.ReadOnly]
    def deploymentId: Optional[Id]
    def description: Optional[StringWithLengthBetween0And1024]
    def lastDeploymentStatusMessage: Optional[__string]
    def lastUpdatedDate: Optional[__timestampIso8601]
    def routeSettings: Optional[
      Map[__string, zio.aws.apigatewayv2.model.RouteSettings.ReadOnly]
    ]
    def stageName: StringWithLengthBetween1And128
    def stageVariables: Optional[Map[__string, StringWithLengthBetween0And2048]]
    def tags: Optional[Map[__string, StringWithLengthBetween1And1600]]
    def getAccessLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.AccessLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogSettings", accessLogSettings)
    def getApiGatewayManaged: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("apiGatewayManaged", apiGatewayManaged)
    def getAutoDeploy: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("autoDeploy", autoDeploy)
    def getClientCertificateId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getCreatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDefaultRouteSettings: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.RouteSettings.ReadOnly
    ] = AwsError.unwrapOptionField("defaultRouteSettings", defaultRouteSettings)
    def getDeploymentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getLastDeploymentStatusMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "lastDeploymentStatusMessage",
        lastDeploymentStatusMessage
      )
    def getLastUpdatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
    def getRouteSettings: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.apigatewayv2.model.RouteSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("routeSettings", routeSettings)
    def getStageName: ZIO[Any, Nothing, StringWithLengthBetween1And128] =
      ZIO.succeed(stageName)
    def getStageVariables
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween0And2048]] =
      AwsError.unwrapOptionField("stageVariables", stageVariables)
    def getTags
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And1600]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.Stage
  ) extends zio.aws.apigatewayv2.model.Stage.ReadOnly {
    override val accessLogSettings
        : Optional[zio.aws.apigatewayv2.model.AccessLogSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessLogSettings())
        .map(value => zio.aws.apigatewayv2.model.AccessLogSettings.wrap(value))
    override val apiGatewayManaged: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.apiGatewayManaged())
      .map(value => value: __boolean)
    override val autoDeploy: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoDeploy())
      .map(value => value: __boolean)
    override val clientCertificateId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.clientCertificateId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val createdDate: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdDate())
        .map(value => value: __timestampIso8601)
    override val defaultRouteSettings
        : Optional[zio.aws.apigatewayv2.model.RouteSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultRouteSettings())
        .map(value => zio.aws.apigatewayv2.model.RouteSettings.wrap(value))
    override val deploymentId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val description: Optional[StringWithLengthBetween0And1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween0And1024(value)
        )
    override val lastDeploymentStatusMessage: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDeploymentStatusMessage())
        .map(value => value: __string)
    override val lastUpdatedDate: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedDate())
        .map(value => value: __timestampIso8601)
    override val routeSettings: Optional[
      Map[__string, zio.aws.apigatewayv2.model.RouteSettings.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.routeSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.RouteSettings
              .wrap(value)
          })
          .toMap
      )
    override val stageName: StringWithLengthBetween1And128 =
      zio.aws.apigatewayv2.model.primitives
        .StringWithLengthBetween1And128(impl.stageName())
    override val stageVariables
        : Optional[Map[__string, StringWithLengthBetween0And2048]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stageVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween0And2048(value)
            })
            .toMap
        )
    override val tags
        : Optional[Map[__string, StringWithLengthBetween1And1600]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And1600(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.Stage
  ): zio.aws.apigatewayv2.model.Stage.ReadOnly = new Wrapper(impl)
}
