package zio.aws.apigatewayv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And1600,
  __string,
  __boolean,
  StringWithLengthBetween1And64,
  StringWithLengthBetween0And1024,
  SelectionExpression,
  __timestampIso8601,
  StringWithLengthBetween1And128,
  Id
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Api(
    apiEndpoint: Optional[__string] = Optional.Absent,
    apiGatewayManaged: Optional[__boolean] = Optional.Absent,
    apiId: Optional[Id] = Optional.Absent,
    apiKeySelectionExpression: Optional[SelectionExpression] = Optional.Absent,
    corsConfiguration: Optional[zio.aws.apigatewayv2.model.Cors] =
      Optional.Absent,
    createdDate: Optional[__timestampIso8601] = Optional.Absent,
    description: Optional[StringWithLengthBetween0And1024] = Optional.Absent,
    disableSchemaValidation: Optional[__boolean] = Optional.Absent,
    disableExecuteApiEndpoint: Optional[__boolean] = Optional.Absent,
    importInfo: Optional[Iterable[__string]] = Optional.Absent,
    name: StringWithLengthBetween1And128,
    protocolType: zio.aws.apigatewayv2.model.ProtocolType,
    routeSelectionExpression: SelectionExpression,
    tags: Optional[Map[__string, StringWithLengthBetween1And1600]] =
      Optional.Absent,
    version: Optional[StringWithLengthBetween1And64] = Optional.Absent,
    warnings: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.Api = {
    import Api.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.Api
      .builder()
      .optionallyWith(apiEndpoint.map(value => value: java.lang.String))(
        _.apiEndpoint
      )
      .optionallyWith(apiGatewayManaged.map(value => value: java.lang.Boolean))(
        _.apiGatewayManaged
      )
      .optionallyWith(apiId.map(value => Id.unwrap(value): java.lang.String))(
        _.apiId
      )
      .optionallyWith(
        apiKeySelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.apiKeySelectionExpression)
      .optionallyWith(corsConfiguration.map(value => value.buildAwsValue()))(
        _.corsConfiguration
      )
      .optionallyWith(createdDate.map(value => value: Instant))(_.createdDate)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        disableSchemaValidation.map(value => value: java.lang.Boolean)
      )(_.disableSchemaValidation)
      .optionallyWith(
        disableExecuteApiEndpoint.map(value => value: java.lang.Boolean)
      )(_.disableExecuteApiEndpoint)
      .optionallyWith(
        importInfo.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.importInfo)
      .name(StringWithLengthBetween1And128.unwrap(name): java.lang.String)
      .protocolType(protocolType.unwrap)
      .routeSelectionExpression(
        SelectionExpression.unwrap(routeSelectionExpression): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And1600
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        version.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.version)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.warnings)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.Api.ReadOnly =
    zio.aws.apigatewayv2.model.Api.wrap(buildAwsValue())
}
object Api {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.apigatewayv2.model.Api] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.Api =
      zio.aws.apigatewayv2.model.Api(
        apiEndpoint.map(value => value),
        apiGatewayManaged.map(value => value),
        apiId.map(value => value),
        apiKeySelectionExpression.map(value => value),
        corsConfiguration.map(value => value.asEditable),
        createdDate.map(value => value),
        description.map(value => value),
        disableSchemaValidation.map(value => value),
        disableExecuteApiEndpoint.map(value => value),
        importInfo.map(value => value),
        name,
        protocolType,
        routeSelectionExpression,
        tags.map(value => value),
        version.map(value => value),
        warnings.map(value => value)
      )
    def apiEndpoint: Optional[__string]
    def apiGatewayManaged: Optional[__boolean]
    def apiId: Optional[Id]
    def apiKeySelectionExpression: Optional[SelectionExpression]
    def corsConfiguration: Optional[zio.aws.apigatewayv2.model.Cors.ReadOnly]
    def createdDate: Optional[__timestampIso8601]
    def description: Optional[StringWithLengthBetween0And1024]
    def disableSchemaValidation: Optional[__boolean]
    def disableExecuteApiEndpoint: Optional[__boolean]
    def importInfo: Optional[List[__string]]
    def name: StringWithLengthBetween1And128
    def protocolType: zio.aws.apigatewayv2.model.ProtocolType
    def routeSelectionExpression: SelectionExpression
    def tags: Optional[Map[__string, StringWithLengthBetween1And1600]]
    def version: Optional[StringWithLengthBetween1And64]
    def warnings: Optional[List[__string]]
    def getApiEndpoint: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiEndpoint", apiEndpoint)
    def getApiGatewayManaged: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("apiGatewayManaged", apiGatewayManaged)
    def getApiId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getApiKeySelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "apiKeySelectionExpression",
        apiKeySelectionExpression
      )
    def getCorsConfiguration
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.Cors.ReadOnly] =
      AwsError.unwrapOptionField("corsConfiguration", corsConfiguration)
    def getCreatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getDisableSchemaValidation: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("disableSchemaValidation", disableSchemaValidation)
    def getDisableExecuteApiEndpoint: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("disableExecuteApiEndpoint", disableExecuteApiEndpoint)
    def getImportInfo: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("importInfo", importInfo)
    def getName: ZIO[Any, Nothing, StringWithLengthBetween1And128] =
      ZIO.succeed(name)
    def getProtocolType
        : ZIO[Any, Nothing, zio.aws.apigatewayv2.model.ProtocolType] =
      ZIO.succeed(protocolType)
    def getRouteSelectionExpression: ZIO[Any, Nothing, SelectionExpression] =
      ZIO.succeed(routeSelectionExpression)
    def getTags
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And1600]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVersion: ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("version", version)
    def getWarnings: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("warnings", warnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.Api
  ) extends zio.aws.apigatewayv2.model.Api.ReadOnly {
    override val apiEndpoint: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.apiEndpoint())
      .map(value => value: __string)
    override val apiGatewayManaged: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.apiGatewayManaged())
      .map(value => value: __boolean)
    override val apiId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.apiId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val apiKeySelectionExpression: Optional[SelectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiKeySelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
    override val corsConfiguration
        : Optional[zio.aws.apigatewayv2.model.Cors.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.corsConfiguration())
        .map(value => zio.aws.apigatewayv2.model.Cors.wrap(value))
    override val createdDate: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdDate())
        .map(value => value: __timestampIso8601)
    override val description: Optional[StringWithLengthBetween0And1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween0And1024(value)
        )
    override val disableSchemaValidation: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableSchemaValidation())
        .map(value => value: __boolean)
    override val disableExecuteApiEndpoint: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableExecuteApiEndpoint())
        .map(value => value: __boolean)
    override val importInfo: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.importInfo())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val name: StringWithLengthBetween1And128 =
      zio.aws.apigatewayv2.model.primitives
        .StringWithLengthBetween1And128(impl.name())
    override val protocolType: zio.aws.apigatewayv2.model.ProtocolType =
      zio.aws.apigatewayv2.model.ProtocolType.wrap(impl.protocolType())
    override val routeSelectionExpression: SelectionExpression =
      zio.aws.apigatewayv2.model.primitives
        .SelectionExpression(impl.routeSelectionExpression())
    override val tags
        : Optional[Map[__string, StringWithLengthBetween1And1600]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And1600(value)
            })
            .toMap
        )
    override val version: Optional[StringWithLengthBetween1And64] =
      zio.aws.core.internal
        .optionalFromNullable(impl.version())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And64(value)
        )
    override val warnings: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.Api
  ): zio.aws.apigatewayv2.model.Api.ReadOnly = new Wrapper(impl)
}
