package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetModelsRequest(
    apiId: __string,
    maxResults: Optional[__string] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetModelsRequest = {
    import GetModelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetModelsRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(maxResults.map(value => value: java.lang.String))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetModelsRequest.ReadOnly =
    zio.aws.apigatewayv2.model.GetModelsRequest.wrap(buildAwsValue())
}
object GetModelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetModelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetModelsRequest =
      zio.aws.apigatewayv2.model.GetModelsRequest(
        apiId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def apiId: __string
    def maxResults: Optional[__string]
    def nextToken: Optional[__string]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getMaxResults: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetModelsRequest
  ) extends zio.aws.apigatewayv2.model.GetModelsRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val maxResults: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: __string)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetModelsRequest
  ): zio.aws.apigatewayv2.model.GetModelsRequest.ReadOnly = new Wrapper(impl)
}
