package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  __boolean,
  SelectionKey,
  StringWithLengthBetween1And64,
  SelectionExpression,
  StringWithLengthBetween1And128,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateRouteRequest(
    apiId: __string,
    apiKeyRequired: Optional[__boolean] = Optional.Absent,
    authorizationScopes: Optional[Iterable[StringWithLengthBetween1And64]] =
      Optional.Absent,
    authorizationType: Optional[zio.aws.apigatewayv2.model.AuthorizationType] =
      Optional.Absent,
    authorizerId: Optional[Id] = Optional.Absent,
    modelSelectionExpression: Optional[SelectionExpression] = Optional.Absent,
    operationName: Optional[StringWithLengthBetween1And64] = Optional.Absent,
    requestModels: Optional[Map[__string, StringWithLengthBetween1And128]] =
      Optional.Absent,
    requestParameters: Optional[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints]
    ] = Optional.Absent,
    routeId: __string,
    routeKey: Optional[SelectionKey] = Optional.Absent,
    routeResponseSelectionExpression: Optional[SelectionExpression] =
      Optional.Absent,
    target: Optional[StringWithLengthBetween1And128] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteRequest = {
    import UpdateRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(apiKeyRequired.map(value => value: java.lang.Boolean))(
        _.apiKeyRequired
      )
      .optionallyWith(
        authorizationScopes.map(value =>
          value.map { item =>
            StringWithLengthBetween1And64.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.authorizationScopes)
      .optionallyWith(authorizationType.map(value => value.unwrap))(
        _.authorizationType
      )
      .optionallyWith(
        authorizerId.map(value => Id.unwrap(value): java.lang.String)
      )(_.authorizerId)
      .optionallyWith(
        modelSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.modelSelectionExpression)
      .optionallyWith(
        operationName.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.operationName)
      .optionallyWith(
        requestModels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And128.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.requestModels)
      .optionallyWith(
        requestParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.requestParameters)
      .routeId(routeId: java.lang.String)
      .optionallyWith(
        routeKey.map(value => SelectionKey.unwrap(value): java.lang.String)
      )(_.routeKey)
      .optionallyWith(
        routeResponseSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.routeResponseSelectionExpression)
      .optionallyWith(
        target.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.target)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateRouteRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateRouteRequest.wrap(buildAwsValue())
}
object UpdateRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateRouteRequest =
      zio.aws.apigatewayv2.model.UpdateRouteRequest(
        apiId,
        apiKeyRequired.map(value => value),
        authorizationScopes.map(value => value),
        authorizationType.map(value => value),
        authorizerId.map(value => value),
        modelSelectionExpression.map(value => value),
        operationName.map(value => value),
        requestModels.map(value => value),
        requestParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        routeId,
        routeKey.map(value => value),
        routeResponseSelectionExpression.map(value => value),
        target.map(value => value)
      )
    def apiId: __string
    def apiKeyRequired: Optional[__boolean]
    def authorizationScopes: Optional[List[StringWithLengthBetween1And64]]
    def authorizationType
        : Optional[zio.aws.apigatewayv2.model.AuthorizationType]
    def authorizerId: Optional[Id]
    def modelSelectionExpression: Optional[SelectionExpression]
    def operationName: Optional[StringWithLengthBetween1And64]
    def requestModels: Optional[Map[__string, StringWithLengthBetween1And128]]
    def requestParameters: Optional[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ]
    def routeId: __string
    def routeKey: Optional[SelectionKey]
    def routeResponseSelectionExpression: Optional[SelectionExpression]
    def target: Optional[StringWithLengthBetween1And128]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getApiKeyRequired: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("apiKeyRequired", apiKeyRequired)
    def getAuthorizationScopes
        : ZIO[Any, AwsError, List[StringWithLengthBetween1And64]] =
      AwsError.unwrapOptionField("authorizationScopes", authorizationScopes)
    def getAuthorizationType
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.AuthorizationType] =
      AwsError.unwrapOptionField("authorizationType", authorizationType)
    def getAuthorizerId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("authorizerId", authorizerId)
    def getModelSelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "modelSelectionExpression",
        modelSelectionExpression
      )
    def getOperationName: ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("operationName", operationName)
    def getRequestModels
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And128]] =
      AwsError.unwrapOptionField("requestModels", requestModels)
    def getRequestParameters: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly
    ]] = AwsError.unwrapOptionField("requestParameters", requestParameters)
    def getRouteId: ZIO[Any, Nothing, __string] = ZIO.succeed(routeId)
    def getRouteKey: ZIO[Any, AwsError, SelectionKey] =
      AwsError.unwrapOptionField("routeKey", routeKey)
    def getRouteResponseSelectionExpression
        : ZIO[Any, AwsError, SelectionExpression] = AwsError.unwrapOptionField(
      "routeResponseSelectionExpression",
      routeResponseSelectionExpression
    )
    def getTarget: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("target", target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteRequest
  ) extends zio.aws.apigatewayv2.model.UpdateRouteRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val apiKeyRequired: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.apiKeyRequired())
      .map(value => value: __boolean)
    override val authorizationScopes
        : Optional[List[StringWithLengthBetween1And64]] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizationScopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And64(item)
        }.toList
      )
    override val authorizationType
        : Optional[zio.aws.apigatewayv2.model.AuthorizationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizationType())
        .map(value => zio.aws.apigatewayv2.model.AuthorizationType.wrap(value))
    override val authorizerId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizerId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val modelSelectionExpression: Optional[SelectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
    override val operationName: Optional[StringWithLengthBetween1And64] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationName())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And64(value)
        )
    override val requestModels
        : Optional[Map[__string, StringWithLengthBetween1And128]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestModels())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And128(value)
            })
            .toMap
        )
    override val requestParameters: Optional[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requestParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.ParameterConstraints
              .wrap(value)
          })
          .toMap
      )
    override val routeId: __string = impl.routeId(): __string
    override val routeKey: Optional[SelectionKey] = zio.aws.core.internal
      .optionalFromNullable(impl.routeKey())
      .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
    override val routeResponseSelectionExpression
        : Optional[SelectionExpression] = zio.aws.core.internal
      .optionalFromNullable(impl.routeResponseSelectionExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
      )
    override val target: Optional[StringWithLengthBetween1And128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.target())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And128(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteRequest
  ): zio.aws.apigatewayv2.model.UpdateRouteRequest.ReadOnly = new Wrapper(impl)
}
