package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  SelectionKey,
  SelectionExpression,
  StringWithLengthBetween1And512,
  StringWithLengthBetween0And32K,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetIntegrationResponseResponse(
    contentHandlingStrategy: Optional[
      zio.aws.apigatewayv2.model.ContentHandlingStrategy
    ] = Optional.Absent,
    integrationResponseId: Optional[Id] = Optional.Absent,
    integrationResponseKey: Optional[SelectionKey] = Optional.Absent,
    responseParameters: Optional[
      Map[__string, StringWithLengthBetween1And512]
    ] = Optional.Absent,
    responseTemplates: Optional[Map[__string, StringWithLengthBetween0And32K]] =
      Optional.Absent,
    templateSelectionExpression: Optional[SelectionExpression] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponseResponse = {
    import GetIntegrationResponseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponseResponse
      .builder()
      .optionallyWith(contentHandlingStrategy.map(value => value.unwrap))(
        _.contentHandlingStrategy
      )
      .optionallyWith(
        integrationResponseId.map(value => Id.unwrap(value): java.lang.String)
      )(_.integrationResponseId)
      .optionallyWith(
        integrationResponseKey.map(value =>
          SelectionKey.unwrap(value): java.lang.String
        )
      )(_.integrationResponseKey)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And512.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        responseTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween0And32K
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.responseTemplates)
      .optionallyWith(
        templateSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.templateSelectionExpression)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewayv2.model.GetIntegrationResponseResponse.ReadOnly =
    zio.aws.apigatewayv2.model.GetIntegrationResponseResponse
      .wrap(buildAwsValue())
}
object GetIntegrationResponseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetIntegrationResponseResponse =
      zio.aws.apigatewayv2.model.GetIntegrationResponseResponse(
        contentHandlingStrategy.map(value => value),
        integrationResponseId.map(value => value),
        integrationResponseKey.map(value => value),
        responseParameters.map(value => value),
        responseTemplates.map(value => value),
        templateSelectionExpression.map(value => value)
      )
    def contentHandlingStrategy
        : Optional[zio.aws.apigatewayv2.model.ContentHandlingStrategy]
    def integrationResponseId: Optional[Id]
    def integrationResponseKey: Optional[SelectionKey]
    def responseParameters
        : Optional[Map[__string, StringWithLengthBetween1And512]]
    def responseTemplates
        : Optional[Map[__string, StringWithLengthBetween0And32K]]
    def templateSelectionExpression: Optional[SelectionExpression]
    def getContentHandlingStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.ContentHandlingStrategy
    ] = AwsError.unwrapOptionField(
      "contentHandlingStrategy",
      contentHandlingStrategy
    )
    def getIntegrationResponseId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("integrationResponseId", integrationResponseId)
    def getIntegrationResponseKey: ZIO[Any, AwsError, SelectionKey] = AwsError
      .unwrapOptionField("integrationResponseKey", integrationResponseKey)
    def getResponseParameters
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And512]] =
      AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getResponseTemplates
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween0And32K]] =
      AwsError.unwrapOptionField("responseTemplates", responseTemplates)
    def getTemplateSelectionExpression
        : ZIO[Any, AwsError, SelectionExpression] = AwsError.unwrapOptionField(
      "templateSelectionExpression",
      templateSelectionExpression
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponseResponse
  ) extends zio.aws.apigatewayv2.model.GetIntegrationResponseResponse.ReadOnly {
    override val contentHandlingStrategy
        : Optional[zio.aws.apigatewayv2.model.ContentHandlingStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentHandlingStrategy())
        .map(value =>
          zio.aws.apigatewayv2.model.ContentHandlingStrategy.wrap(value)
        )
    override val integrationResponseId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.integrationResponseId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val integrationResponseKey: Optional[SelectionKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.integrationResponseKey())
        .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
    override val responseParameters
        : Optional[Map[__string, StringWithLengthBetween1And512]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And512(value)
            })
            .toMap
        )
    override val responseTemplates
        : Optional[Map[__string, StringWithLengthBetween0And32K]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseTemplates())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween0And32K(value)
            })
            .toMap
        )
    override val templateSelectionExpression: Optional[SelectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponseResponse
  ): zio.aws.apigatewayv2.model.GetIntegrationResponseResponse.ReadOnly =
    new Wrapper(impl)
}
