package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{__boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ImportApiRequest(
    basepath: Option[__string] = None,
    body: __string,
    failOnWarnings: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.ImportApiRequest = {
    import ImportApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.ImportApiRequest
      .builder()
      .optionallyWith(basepath.map(value => value: java.lang.String))(
        _.basepath
      )
      .body(body: java.lang.String)
      .optionallyWith(failOnWarnings.map(value => value: java.lang.Boolean))(
        _.failOnWarnings
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.ImportApiRequest.ReadOnly =
    zio.aws.apigatewayv2.model.ImportApiRequest.wrap(buildAwsValue())
}
object ImportApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.ImportApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.ImportApiRequest =
      zio.aws.apigatewayv2.model.ImportApiRequest(
        basepath.map(value => value),
        body,
        failOnWarnings.map(value => value)
      )
    def basepath: Option[__string]
    def body: __string
    def failOnWarnings: Option[__boolean]
    def getBasepath: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("basepath", basepath)
    def getBody: ZIO[Any, Nothing, __string] = ZIO.succeed(body)
    def getFailOnWarnings: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("failOnWarnings", failOnWarnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ImportApiRequest
  ) extends zio.aws.apigatewayv2.model.ImportApiRequest.ReadOnly {
    override val basepath: Option[__string] =
      scala.Option(impl.basepath()).map(value => value: __string)
    override val body: __string = impl.body(): __string
    override val failOnWarnings: Option[__boolean] =
      scala.Option(impl.failOnWarnings()).map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ImportApiRequest
  ): zio.aws.apigatewayv2.model.ImportApiRequest.ReadOnly = new Wrapper(impl)
}
