package zio.aws.apigatewayv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  __boolean,
  Arn,
  UriWithLengthBetween1And2048,
  StringWithLengthBetween1And64,
  StringWithLengthBetween0And1024,
  SelectionExpression,
  StringWithLengthBetween1And1024,
  StringWithLengthBetween1And512,
  StringWithLengthBetween0And32K,
  StringWithLengthBetween1And128,
  Id,
  IntegerWithLengthBetween50And30000
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetIntegrationResponse(
    apiGatewayManaged: Option[__boolean] = None,
    connectionId: Option[StringWithLengthBetween1And1024] = None,
    connectionType: Option[zio.aws.apigatewayv2.model.ConnectionType] = None,
    contentHandlingStrategy: Option[
      zio.aws.apigatewayv2.model.ContentHandlingStrategy
    ] = None,
    credentialsArn: Option[Arn] = None,
    description: Option[StringWithLengthBetween0And1024] = None,
    integrationId: Option[Id] = None,
    integrationMethod: Option[StringWithLengthBetween1And64] = None,
    integrationResponseSelectionExpression: Option[SelectionExpression] = None,
    integrationSubtype: Option[StringWithLengthBetween1And128] = None,
    integrationType: Option[zio.aws.apigatewayv2.model.IntegrationType] = None,
    integrationUri: Option[UriWithLengthBetween1And2048] = None,
    passthroughBehavior: Option[
      zio.aws.apigatewayv2.model.PassthroughBehavior
    ] = None,
    payloadFormatVersion: Option[StringWithLengthBetween1And64] = None,
    requestParameters: Option[Map[__string, StringWithLengthBetween1And512]] =
      None,
    requestTemplates: Option[Map[__string, StringWithLengthBetween0And32K]] =
      None,
    responseParameters: Option[
      Map[__string, Map[__string, StringWithLengthBetween1And512]]
    ] = None,
    templateSelectionExpression: Option[SelectionExpression] = None,
    timeoutInMillis: Option[IntegerWithLengthBetween50And30000] = None,
    tlsConfig: Option[zio.aws.apigatewayv2.model.TlsConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse = {
    import GetIntegrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse
      .builder()
      .optionallyWith(apiGatewayManaged.map(value => value: java.lang.Boolean))(
        _.apiGatewayManaged
      )
      .optionallyWith(
        connectionId.map(value =>
          StringWithLengthBetween1And1024.unwrap(value): java.lang.String
        )
      )(_.connectionId)
      .optionallyWith(connectionType.map(value => value.unwrap))(
        _.connectionType
      )
      .optionallyWith(contentHandlingStrategy.map(value => value.unwrap))(
        _.contentHandlingStrategy
      )
      .optionallyWith(
        credentialsArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.credentialsArn)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        integrationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.integrationId)
      .optionallyWith(
        integrationMethod.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.integrationMethod)
      .optionallyWith(
        integrationResponseSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.integrationResponseSelectionExpression)
      .optionallyWith(
        integrationSubtype.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.integrationSubtype)
      .optionallyWith(integrationType.map(value => value.unwrap))(
        _.integrationType
      )
      .optionallyWith(
        integrationUri.map(value =>
          UriWithLengthBetween1And2048.unwrap(value): java.lang.String
        )
      )(_.integrationUri)
      .optionallyWith(passthroughBehavior.map(value => value.unwrap))(
        _.passthroughBehavior
      )
      .optionallyWith(
        payloadFormatVersion.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.payloadFormatVersion)
      .optionallyWith(
        requestParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And512.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.requestParameters)
      .optionallyWith(
        requestTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween0And32K.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.requestTemplates)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> (StringWithLengthBetween1And512
                    .unwrap(value): java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        templateSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.templateSelectionExpression)
      .optionallyWith(
        timeoutInMillis.map(value =>
          IntegerWithLengthBetween50And30000.unwrap(value): Integer
        )
      )(_.timeoutInMillis)
      .optionallyWith(tlsConfig.map(value => value.buildAwsValue()))(
        _.tlsConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetIntegrationResponse.ReadOnly =
    zio.aws.apigatewayv2.model.GetIntegrationResponse.wrap(buildAwsValue())
}
object GetIntegrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetIntegrationResponse =
      zio.aws.apigatewayv2.model.GetIntegrationResponse(
        apiGatewayManaged.map(value => value),
        connectionId.map(value => value),
        connectionType.map(value => value),
        contentHandlingStrategy.map(value => value),
        credentialsArn.map(value => value),
        description.map(value => value),
        integrationId.map(value => value),
        integrationMethod.map(value => value),
        integrationResponseSelectionExpression.map(value => value),
        integrationSubtype.map(value => value),
        integrationType.map(value => value),
        integrationUri.map(value => value),
        passthroughBehavior.map(value => value),
        payloadFormatVersion.map(value => value),
        requestParameters.map(value => value),
        requestTemplates.map(value => value),
        responseParameters.map(value => value),
        templateSelectionExpression.map(value => value),
        timeoutInMillis.map(value => value),
        tlsConfig.map(value => value.asEditable)
      )
    def apiGatewayManaged: Option[__boolean]
    def connectionId: Option[StringWithLengthBetween1And1024]
    def connectionType: Option[zio.aws.apigatewayv2.model.ConnectionType]
    def contentHandlingStrategy
        : Option[zio.aws.apigatewayv2.model.ContentHandlingStrategy]
    def credentialsArn: Option[Arn]
    def description: Option[StringWithLengthBetween0And1024]
    def integrationId: Option[Id]
    def integrationMethod: Option[StringWithLengthBetween1And64]
    def integrationResponseSelectionExpression: Option[SelectionExpression]
    def integrationSubtype: Option[StringWithLengthBetween1And128]
    def integrationType: Option[zio.aws.apigatewayv2.model.IntegrationType]
    def integrationUri: Option[UriWithLengthBetween1And2048]
    def passthroughBehavior
        : Option[zio.aws.apigatewayv2.model.PassthroughBehavior]
    def payloadFormatVersion: Option[StringWithLengthBetween1And64]
    def requestParameters: Option[Map[__string, StringWithLengthBetween1And512]]
    def requestTemplates: Option[Map[__string, StringWithLengthBetween0And32K]]
    def responseParameters
        : Option[Map[__string, Map[__string, StringWithLengthBetween1And512]]]
    def templateSelectionExpression: Option[SelectionExpression]
    def timeoutInMillis: Option[IntegerWithLengthBetween50And30000]
    def tlsConfig: Option[zio.aws.apigatewayv2.model.TlsConfig.ReadOnly]
    def getApiGatewayManaged: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("apiGatewayManaged", apiGatewayManaged)
    def getConnectionId: ZIO[Any, AwsError, StringWithLengthBetween1And1024] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getConnectionType
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.ConnectionType] =
      AwsError.unwrapOptionField("connectionType", connectionType)
    def getContentHandlingStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.ContentHandlingStrategy
    ] = AwsError.unwrapOptionField(
      "contentHandlingStrategy",
      contentHandlingStrategy
    )
    def getCredentialsArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("credentialsArn", credentialsArn)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getIntegrationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("integrationId", integrationId)
    def getIntegrationMethod
        : ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("integrationMethod", integrationMethod)
    def getIntegrationResponseSelectionExpression
        : ZIO[Any, AwsError, SelectionExpression] = AwsError.unwrapOptionField(
      "integrationResponseSelectionExpression",
      integrationResponseSelectionExpression
    )
    def getIntegrationSubtype
        : ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("integrationSubtype", integrationSubtype)
    def getIntegrationType
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.IntegrationType] =
      AwsError.unwrapOptionField("integrationType", integrationType)
    def getIntegrationUri: ZIO[Any, AwsError, UriWithLengthBetween1And2048] =
      AwsError.unwrapOptionField("integrationUri", integrationUri)
    def getPassthroughBehavior
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.PassthroughBehavior] =
      AwsError.unwrapOptionField("passthroughBehavior", passthroughBehavior)
    def getPayloadFormatVersion
        : ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("payloadFormatVersion", payloadFormatVersion)
    def getRequestParameters
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And512]] =
      AwsError.unwrapOptionField("requestParameters", requestParameters)
    def getRequestTemplates
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween0And32K]] =
      AwsError.unwrapOptionField("requestTemplates", requestTemplates)
    def getResponseParameters: ZIO[Any, AwsError, Map[
      __string,
      Map[__string, StringWithLengthBetween1And512]
    ]] = AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getTemplateSelectionExpression
        : ZIO[Any, AwsError, SelectionExpression] = AwsError.unwrapOptionField(
      "templateSelectionExpression",
      templateSelectionExpression
    )
    def getTimeoutInMillis
        : ZIO[Any, AwsError, IntegerWithLengthBetween50And30000] =
      AwsError.unwrapOptionField("timeoutInMillis", timeoutInMillis)
    def getTlsConfig
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.TlsConfig.ReadOnly] =
      AwsError.unwrapOptionField("tlsConfig", tlsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse
  ) extends zio.aws.apigatewayv2.model.GetIntegrationResponse.ReadOnly {
    override val apiGatewayManaged: Option[__boolean] =
      scala.Option(impl.apiGatewayManaged()).map(value => value: __boolean)
    override val connectionId: Option[StringWithLengthBetween1And1024] = scala
      .Option(impl.connectionId())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And1024(value)
      )
    override val connectionType
        : Option[zio.aws.apigatewayv2.model.ConnectionType] = scala
      .Option(impl.connectionType())
      .map(value => zio.aws.apigatewayv2.model.ConnectionType.wrap(value))
    override val contentHandlingStrategy
        : Option[zio.aws.apigatewayv2.model.ContentHandlingStrategy] = scala
      .Option(impl.contentHandlingStrategy())
      .map(value =>
        zio.aws.apigatewayv2.model.ContentHandlingStrategy.wrap(value)
      )
    override val credentialsArn: Option[Arn] = scala
      .Option(impl.credentialsArn())
      .map(value => zio.aws.apigatewayv2.model.primitives.Arn(value))
    override val description: Option[StringWithLengthBetween0And1024] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween0And1024(value)
      )
    override val integrationId: Option[Id] = scala
      .Option(impl.integrationId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val integrationMethod: Option[StringWithLengthBetween1And64] =
      scala
        .Option(impl.integrationMethod())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And64(value)
        )
    override val integrationResponseSelectionExpression
        : Option[SelectionExpression] = scala
      .Option(impl.integrationResponseSelectionExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
      )
    override val integrationSubtype: Option[StringWithLengthBetween1And128] =
      scala
        .Option(impl.integrationSubtype())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And128(value)
        )
    override val integrationType
        : Option[zio.aws.apigatewayv2.model.IntegrationType] = scala
      .Option(impl.integrationType())
      .map(value => zio.aws.apigatewayv2.model.IntegrationType.wrap(value))
    override val integrationUri: Option[UriWithLengthBetween1And2048] = scala
      .Option(impl.integrationUri())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .UriWithLengthBetween1And2048(value)
      )
    override val passthroughBehavior
        : Option[zio.aws.apigatewayv2.model.PassthroughBehavior] = scala
      .Option(impl.passthroughBehavior())
      .map(value => zio.aws.apigatewayv2.model.PassthroughBehavior.wrap(value))
    override val payloadFormatVersion: Option[StringWithLengthBetween1And64] =
      scala
        .Option(impl.payloadFormatVersion())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And64(value)
        )
    override val requestParameters
        : Option[Map[__string, StringWithLengthBetween1And512]] = scala
      .Option(impl.requestParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween1And512(value)
          })
          .toMap
      )
    override val requestTemplates
        : Option[Map[__string, StringWithLengthBetween0And32K]] = scala
      .Option(impl.requestTemplates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween0And32K(value)
          })
          .toMap
      )
    override val responseParameters
        : Option[Map[__string, Map[__string, StringWithLengthBetween1And512]]] =
      scala
        .Option(impl.responseParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> value.asScala
                .map({ case (key, value) =>
                  (key: __string) -> zio.aws.apigatewayv2.model.primitives
                    .StringWithLengthBetween1And512(value)
                })
                .toMap
            })
            .toMap
        )
    override val templateSelectionExpression: Option[SelectionExpression] =
      scala
        .Option(impl.templateSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
    override val timeoutInMillis: Option[IntegerWithLengthBetween50And30000] =
      scala
        .Option(impl.timeoutInMillis())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .IntegerWithLengthBetween50And30000(value)
        )
    override val tlsConfig
        : Option[zio.aws.apigatewayv2.model.TlsConfig.ReadOnly] = scala
      .Option(impl.tlsConfig())
      .map(value => zio.aws.apigatewayv2.model.TlsConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetIntegrationResponse
  ): zio.aws.apigatewayv2.model.GetIntegrationResponse.ReadOnly = new Wrapper(
    impl
  )
}
