package zio.aws.apigatewayv2
import zio.aws.apigatewayv2.model.UpdateAuthorizerResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.apigatewayv2.ApiGatewayV2AsyncClient
import zio.aws.apigatewayv2.model.{
  ExportApiRequest,
  UpdateIntegrationRequest,
  DeleteDeploymentRequest,
  DeleteRouteRequest,
  DeleteCorsConfigurationRequest,
  GetDomainNamesRequest,
  CreateIntegrationRequest,
  CreateStageRequest,
  UpdateRouteResponseRequest,
  UpdateApiMappingRequest,
  CreateVpcLinkRequest,
  UpdateIntegrationResponseRequest,
  CreateApiRequest,
  GetIntegrationResponsesRequest,
  UpdateDeploymentRequest,
  GetIntegrationRequest,
  DeleteVpcLinkRequest,
  DeleteApiMappingRequest,
  UpdateVpcLinkRequest,
  GetApisRequest,
  DeleteStageRequest,
  ReimportApiRequest,
  GetAuthorizerRequest,
  CreateAuthorizerRequest,
  GetStagesRequest,
  CreateIntegrationResponseRequest,
  GetDeploymentsRequest,
  DeleteAccessLogSettingsRequest,
  ImportApiRequest,
  CreateRouteRequest,
  CreateModelRequest,
  GetApiRequest,
  DeleteApiRequest,
  DeleteIntegrationRequest,
  DeleteRouteResponseRequest,
  CreateApiMappingRequest,
  DeleteRouteSettingsRequest,
  GetIntegrationResponseRequest,
  GetRoutesRequest,
  GetApiMappingRequest,
  ResetAuthorizersCacheRequest,
  DeleteAuthorizerRequest,
  UpdateApiRequest,
  GetVpcLinksRequest,
  GetRouteRequest,
  GetModelTemplateRequest,
  DeleteDomainNameRequest,
  UpdateRouteRequest,
  GetIntegrationsRequest,
  UpdateDomainNameRequest,
  CreateDomainNameRequest,
  GetVpcLinkRequest,
  CreateRouteResponseRequest,
  GetApiMappingsRequest,
  UntagResourceRequest,
  GetStageRequest,
  UpdateStageRequest,
  GetTagsRequest,
  DeleteIntegrationResponseRequest,
  CreateDeploymentRequest,
  UpdateModelRequest,
  GetModelRequest,
  GetDeploymentRequest,
  GetModelsRequest,
  DeleteModelRequest,
  DeleteRouteRequestParameterRequest,
  GetAuthorizersRequest,
  GetDomainNameRequest,
  GetRouteResponsesRequest,
  GetRouteResponseRequest,
  TagResourceRequest,
  UpdateAuthorizerRequest
}
import zio.stream.ZStream
object ApiGatewayV2Mock extends Mock[ApiGatewayV2] {
  object UpdateRouteResponse
      extends Effect[
        UpdateRouteResponseRequest,
        AwsError,
        zio.aws.apigatewayv2.model.UpdateRouteResponseResponse.ReadOnly
      ]
  object ResetAuthorizersCache
      extends Effect[ResetAuthorizersCacheRequest, AwsError, Unit]
  object UpdateStage
      extends Effect[
        UpdateStageRequest,
        AwsError,
        zio.aws.apigatewayv2.model.UpdateStageResponse.ReadOnly
      ]
  object GetVpcLinks
      extends Stream[
        GetVpcLinksRequest,
        AwsError,
        zio.aws.apigatewayv2.model.VpcLink.ReadOnly
      ]
  object GetVpcLinksPaginated
      extends Effect[
        GetVpcLinksRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetVpcLinksResponse.ReadOnly
      ]
  object CreateRoute
      extends Effect[
        CreateRouteRequest,
        AwsError,
        zio.aws.apigatewayv2.model.CreateRouteResponse.ReadOnly
      ]
  object DeleteRoute extends Effect[DeleteRouteRequest, AwsError, Unit]
  object ImportApi
      extends Effect[
        ImportApiRequest,
        AwsError,
        zio.aws.apigatewayv2.model.ImportApiResponse.ReadOnly
      ]
  object GetRouteResponses
      extends Stream[
        GetRouteResponsesRequest,
        AwsError,
        zio.aws.apigatewayv2.model.RouteResponse.ReadOnly
      ]
  object GetRouteResponsesPaginated
      extends Effect[
        GetRouteResponsesRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetRouteResponsesResponse.ReadOnly
      ]
  object GetDomainNames
      extends Stream[
        GetDomainNamesRequest,
        AwsError,
        zio.aws.apigatewayv2.model.DomainName.ReadOnly
      ]
  object GetDomainNamesPaginated
      extends Effect[
        GetDomainNamesRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetDomainNamesResponse.ReadOnly
      ]
  object UpdateRoute
      extends Effect[
        UpdateRouteRequest,
        AwsError,
        zio.aws.apigatewayv2.model.UpdateRouteResponse.ReadOnly
      ]
  object GetRouteResponse
      extends Effect[
        GetRouteResponseRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetRouteResponseResponse.ReadOnly
      ]
  object CreateModel
      extends Effect[
        CreateModelRequest,
        AwsError,
        zio.aws.apigatewayv2.model.CreateModelResponse.ReadOnly
      ]
  object ExportApi
      extends Effect[
        ExportApiRequest,
        AwsError,
        zio.aws.apigatewayv2.model.ExportApiResponse.ReadOnly
      ]
  object UpdateModel
      extends Effect[
        UpdateModelRequest,
        AwsError,
        zio.aws.apigatewayv2.model.UpdateModelResponse.ReadOnly
      ]
  object DeleteAccessLogSettings
      extends Effect[DeleteAccessLogSettingsRequest, AwsError, Unit]
  object DeleteVpcLink
      extends Effect[
        DeleteVpcLinkRequest,
        AwsError,
        zio.aws.apigatewayv2.model.DeleteVpcLinkResponse.ReadOnly
      ]
  object GetVpcLink
      extends Effect[
        GetVpcLinkRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetVpcLinkResponse.ReadOnly
      ]
  object DeleteApi extends Effect[DeleteApiRequest, AwsError, Unit]
  object GetDeployment
      extends Effect[
        GetDeploymentRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetDeploymentResponse.ReadOnly
      ]
  object DeleteDeployment
      extends Effect[DeleteDeploymentRequest, AwsError, Unit]
  object DeleteCorsConfiguration
      extends Effect[DeleteCorsConfigurationRequest, AwsError, Unit]
  object GetStage
      extends Effect[
        GetStageRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetStageResponse.ReadOnly
      ]
  object DeleteIntegration
      extends Effect[DeleteIntegrationRequest, AwsError, Unit]
  object UpdateDeployment
      extends Effect[
        UpdateDeploymentRequest,
        AwsError,
        zio.aws.apigatewayv2.model.UpdateDeploymentResponse.ReadOnly
      ]
  object GetIntegrationResponse
      extends Effect[
        GetIntegrationResponseRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetIntegrationResponseResponse.ReadOnly
      ]
  object GetApiMappings
      extends Stream[
        GetApiMappingsRequest,
        AwsError,
        zio.aws.apigatewayv2.model.ApiMapping.ReadOnly
      ]
  object GetApiMappingsPaginated
      extends Effect[
        GetApiMappingsRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetApiMappingsResponse.ReadOnly
      ]
  object UpdateVpcLink
      extends Effect[
        UpdateVpcLinkRequest,
        AwsError,
        zio.aws.apigatewayv2.model.UpdateVpcLinkResponse.ReadOnly
      ]
  object GetModel
      extends Effect[
        GetModelRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetModelResponse.ReadOnly
      ]
  object UpdateAuthorizer
      extends Effect[UpdateAuthorizerRequest, AwsError, ReadOnly]
  object DeleteRouteRequestParameter
      extends Effect[DeleteRouteRequestParameterRequest, AwsError, Unit]
  object DeleteStage extends Effect[DeleteStageRequest, AwsError, Unit]
  object DeleteApiMapping
      extends Effect[DeleteApiMappingRequest, AwsError, Unit]
  object CreateApiMapping
      extends Effect[
        CreateApiMappingRequest,
        AwsError,
        zio.aws.apigatewayv2.model.CreateApiMappingResponse.ReadOnly
      ]
  object DeleteModel extends Effect[DeleteModelRequest, AwsError, Unit]
  object CreateDomainName
      extends Effect[
        CreateDomainNameRequest,
        AwsError,
        zio.aws.apigatewayv2.model.CreateDomainNameResponse.ReadOnly
      ]
  object ReimportApi
      extends Effect[
        ReimportApiRequest,
        AwsError,
        zio.aws.apigatewayv2.model.ReimportApiResponse.ReadOnly
      ]
  object GetApi
      extends Effect[
        GetApiRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetApiResponse.ReadOnly
      ]
  object DeleteRouteSettings
      extends Effect[DeleteRouteSettingsRequest, AwsError, Unit]
  object CreateApi
      extends Effect[
        CreateApiRequest,
        AwsError,
        zio.aws.apigatewayv2.model.CreateApiResponse.ReadOnly
      ]
  object CreateVpcLink
      extends Effect[
        CreateVpcLinkRequest,
        AwsError,
        zio.aws.apigatewayv2.model.CreateVpcLinkResponse.ReadOnly
      ]
  object UpdateApi
      extends Effect[
        UpdateApiRequest,
        AwsError,
        zio.aws.apigatewayv2.model.UpdateApiResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object GetAuthorizers
      extends Stream[
        GetAuthorizersRequest,
        AwsError,
        zio.aws.apigatewayv2.model.Authorizer.ReadOnly
      ]
  object GetAuthorizersPaginated
      extends Effect[
        GetAuthorizersRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetAuthorizersResponse.ReadOnly
      ]
  object UpdateIntegrationResponse
      extends Effect[
        UpdateIntegrationResponseRequest,
        AwsError,
        zio.aws.apigatewayv2.model.UpdateIntegrationResponseResponse.ReadOnly
      ]
  object CreateDeployment
      extends Effect[
        CreateDeploymentRequest,
        AwsError,
        zio.aws.apigatewayv2.model.CreateDeploymentResponse.ReadOnly
      ]
  object GetRoute
      extends Effect[
        GetRouteRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetRouteResponse.ReadOnly
      ]
  object GetModelTemplate
      extends Effect[
        GetModelTemplateRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetModelTemplateResponse.ReadOnly
      ]
  object CreateStage
      extends Effect[
        CreateStageRequest,
        AwsError,
        zio.aws.apigatewayv2.model.CreateStageResponse.ReadOnly
      ]
  object GetApiMapping
      extends Effect[
        GetApiMappingRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetApiMappingResponse.ReadOnly
      ]
  object CreateAuthorizer
      extends Effect[
        CreateAuthorizerRequest,
        AwsError,
        zio.aws.apigatewayv2.model.CreateAuthorizerResponse.ReadOnly
      ]
  object CreateRouteResponse
      extends Effect[
        CreateRouteResponseRequest,
        AwsError,
        zio.aws.apigatewayv2.model.CreateRouteResponseResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.apigatewayv2.model.TagResourceResponse.ReadOnly
      ]
  object GetIntegration
      extends Effect[
        GetIntegrationRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetIntegrationResponse.ReadOnly
      ]
  object CreateIntegrationResponse
      extends Effect[
        CreateIntegrationResponseRequest,
        AwsError,
        zio.aws.apigatewayv2.model.CreateIntegrationResponseResponse.ReadOnly
      ]
  object GetDeployments
      extends Stream[
        GetDeploymentsRequest,
        AwsError,
        zio.aws.apigatewayv2.model.Deployment.ReadOnly
      ]
  object GetDeploymentsPaginated
      extends Effect[
        GetDeploymentsRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetDeploymentsResponse.ReadOnly
      ]
  object UpdateApiMapping
      extends Effect[
        UpdateApiMappingRequest,
        AwsError,
        zio.aws.apigatewayv2.model.UpdateApiMappingResponse.ReadOnly
      ]
  object DeleteAuthorizer
      extends Effect[DeleteAuthorizerRequest, AwsError, Unit]
  object DeleteIntegrationResponse
      extends Effect[DeleteIntegrationResponseRequest, AwsError, Unit]
  object GetIntegrationResponses
      extends Stream[
        GetIntegrationResponsesRequest,
        AwsError,
        zio.aws.apigatewayv2.model.IntegrationResponse.ReadOnly
      ]
  object GetIntegrationResponsesPaginated
      extends Effect[
        GetIntegrationResponsesRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetIntegrationResponsesResponse.ReadOnly
      ]
  object UpdateIntegration
      extends Effect[
        UpdateIntegrationRequest,
        AwsError,
        zio.aws.apigatewayv2.model.UpdateIntegrationResponse.ReadOnly
      ]
  object CreateIntegration
      extends Effect[
        CreateIntegrationRequest,
        AwsError,
        zio.aws.apigatewayv2.model.CreateIntegrationResponse.ReadOnly
      ]
  object GetModels
      extends Stream[
        GetModelsRequest,
        AwsError,
        zio.aws.apigatewayv2.model.Model.ReadOnly
      ]
  object GetModelsPaginated
      extends Effect[
        GetModelsRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetModelsResponse.ReadOnly
      ]
  object GetStages
      extends Stream[
        GetStagesRequest,
        AwsError,
        zio.aws.apigatewayv2.model.Stage.ReadOnly
      ]
  object GetStagesPaginated
      extends Effect[
        GetStagesRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetStagesResponse.ReadOnly
      ]
  object GetDomainName
      extends Effect[
        GetDomainNameRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetDomainNameResponse.ReadOnly
      ]
  object GetIntegrations
      extends Stream[
        GetIntegrationsRequest,
        AwsError,
        zio.aws.apigatewayv2.model.Integration.ReadOnly
      ]
  object GetIntegrationsPaginated
      extends Effect[
        GetIntegrationsRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetIntegrationsResponse.ReadOnly
      ]
  object GetRoutes
      extends Stream[
        GetRoutesRequest,
        AwsError,
        zio.aws.apigatewayv2.model.Route.ReadOnly
      ]
  object GetRoutesPaginated
      extends Effect[
        GetRoutesRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetRoutesResponse.ReadOnly
      ]
  object GetAuthorizer
      extends Effect[
        GetAuthorizerRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetAuthorizerResponse.ReadOnly
      ]
  object DeleteDomainName
      extends Effect[DeleteDomainNameRequest, AwsError, Unit]
  object GetApis
      extends Stream[
        GetApisRequest,
        AwsError,
        zio.aws.apigatewayv2.model.Api.ReadOnly
      ]
  object GetApisPaginated
      extends Effect[
        GetApisRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetApisResponse.ReadOnly
      ]
  object DeleteRouteResponse
      extends Effect[DeleteRouteResponseRequest, AwsError, Unit]
  object UpdateDomainName
      extends Effect[
        UpdateDomainNameRequest,
        AwsError,
        zio.aws.apigatewayv2.model.UpdateDomainNameResponse.ReadOnly
      ]
  object GetTags
      extends Effect[
        GetTagsRequest,
        AwsError,
        zio.aws.apigatewayv2.model.GetTagsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ApiGatewayV2] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ApiGatewayV2 {
          val api: ApiGatewayV2AsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ApiGatewayV2 = this
          def updateRouteResponse(request: UpdateRouteResponseRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.UpdateRouteResponseResponse.ReadOnly
          ] = proxy(UpdateRouteResponse, request)
          def resetAuthorizersCache(
              request: ResetAuthorizersCacheRequest
          ): IO[AwsError, Unit] = proxy(ResetAuthorizersCache, request)
          def updateStage(request: UpdateStageRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.UpdateStageResponse.ReadOnly
          ] = proxy(UpdateStage, request)
          def getVpcLinks(request: GetVpcLinksRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigatewayv2.model.VpcLink.ReadOnly
          ] = rts.unsafeRun(proxy(GetVpcLinks, request))
          def getVpcLinksPaginated(request: GetVpcLinksRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetVpcLinksResponse.ReadOnly
          ] = proxy(GetVpcLinksPaginated, request)
          def createRoute(request: CreateRouteRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.CreateRouteResponse.ReadOnly
          ] = proxy(CreateRoute, request)
          def deleteRoute(request: DeleteRouteRequest): IO[AwsError, Unit] =
            proxy(DeleteRoute, request)
          def importApi(request: ImportApiRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.ImportApiResponse.ReadOnly
          ] = proxy(ImportApi, request)
          def getRouteResponses(request: GetRouteResponsesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigatewayv2.model.RouteResponse.ReadOnly
          ] = rts.unsafeRun(proxy(GetRouteResponses, request))
          def getRouteResponsesPaginated(request: GetRouteResponsesRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetRouteResponsesResponse.ReadOnly
          ] = proxy(GetRouteResponsesPaginated, request)
          def getDomainNames(request: GetDomainNamesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigatewayv2.model.DomainName.ReadOnly
          ] = rts.unsafeRun(proxy(GetDomainNames, request))
          def getDomainNamesPaginated(request: GetDomainNamesRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetDomainNamesResponse.ReadOnly
          ] = proxy(GetDomainNamesPaginated, request)
          def updateRoute(request: UpdateRouteRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.UpdateRouteResponse.ReadOnly
          ] = proxy(UpdateRoute, request)
          def getRouteResponse(request: GetRouteResponseRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetRouteResponseResponse.ReadOnly
          ] = proxy(GetRouteResponse, request)
          def createModel(request: CreateModelRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.CreateModelResponse.ReadOnly
          ] = proxy(CreateModel, request)
          def exportApi(request: ExportApiRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.ExportApiResponse.ReadOnly
          ] = proxy(ExportApi, request)
          def updateModel(request: UpdateModelRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.UpdateModelResponse.ReadOnly
          ] = proxy(UpdateModel, request)
          def deleteAccessLogSettings(
              request: DeleteAccessLogSettingsRequest
          ): IO[AwsError, Unit] = proxy(DeleteAccessLogSettings, request)
          def deleteVpcLink(request: DeleteVpcLinkRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.DeleteVpcLinkResponse.ReadOnly
          ] = proxy(DeleteVpcLink, request)
          def getVpcLink(request: GetVpcLinkRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetVpcLinkResponse.ReadOnly
          ] = proxy(GetVpcLink, request)
          def deleteApi(request: DeleteApiRequest): IO[AwsError, Unit] =
            proxy(DeleteApi, request)
          def getDeployment(request: GetDeploymentRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetDeploymentResponse.ReadOnly
          ] = proxy(GetDeployment, request)
          def deleteDeployment(
              request: DeleteDeploymentRequest
          ): IO[AwsError, Unit] = proxy(DeleteDeployment, request)
          def deleteCorsConfiguration(
              request: DeleteCorsConfigurationRequest
          ): IO[AwsError, Unit] = proxy(DeleteCorsConfiguration, request)
          def getStage(request: GetStageRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetStageResponse.ReadOnly
          ] = proxy(GetStage, request)
          def deleteIntegration(
              request: DeleteIntegrationRequest
          ): IO[AwsError, Unit] = proxy(DeleteIntegration, request)
          def updateDeployment(request: UpdateDeploymentRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.UpdateDeploymentResponse.ReadOnly
          ] = proxy(UpdateDeployment, request)
          def getIntegrationResponse(
              request: GetIntegrationResponseRequest
          ): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetIntegrationResponseResponse.ReadOnly
          ] = proxy(GetIntegrationResponse, request)
          def getApiMappings(request: GetApiMappingsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigatewayv2.model.ApiMapping.ReadOnly
          ] = rts.unsafeRun(proxy(GetApiMappings, request))
          def getApiMappingsPaginated(request: GetApiMappingsRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetApiMappingsResponse.ReadOnly
          ] = proxy(GetApiMappingsPaginated, request)
          def updateVpcLink(request: UpdateVpcLinkRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.UpdateVpcLinkResponse.ReadOnly
          ] = proxy(UpdateVpcLink, request)
          def getModel(request: GetModelRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetModelResponse.ReadOnly
          ] = proxy(GetModel, request)
          def updateAuthorizer(
              request: UpdateAuthorizerRequest
          ): IO[AwsError, ReadOnly] = proxy(UpdateAuthorizer, request)
          def deleteRouteRequestParameter(
              request: DeleteRouteRequestParameterRequest
          ): IO[AwsError, Unit] = proxy(DeleteRouteRequestParameter, request)
          def deleteStage(request: DeleteStageRequest): IO[AwsError, Unit] =
            proxy(DeleteStage, request)
          def deleteApiMapping(
              request: DeleteApiMappingRequest
          ): IO[AwsError, Unit] = proxy(DeleteApiMapping, request)
          def createApiMapping(request: CreateApiMappingRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.CreateApiMappingResponse.ReadOnly
          ] = proxy(CreateApiMapping, request)
          def deleteModel(request: DeleteModelRequest): IO[AwsError, Unit] =
            proxy(DeleteModel, request)
          def createDomainName(request: CreateDomainNameRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.CreateDomainNameResponse.ReadOnly
          ] = proxy(CreateDomainName, request)
          def reimportApi(request: ReimportApiRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.ReimportApiResponse.ReadOnly
          ] = proxy(ReimportApi, request)
          def getApi(
              request: GetApiRequest
          ): IO[AwsError, zio.aws.apigatewayv2.model.GetApiResponse.ReadOnly] =
            proxy(GetApi, request)
          def deleteRouteSettings(
              request: DeleteRouteSettingsRequest
          ): IO[AwsError, Unit] = proxy(DeleteRouteSettings, request)
          def createApi(request: CreateApiRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.CreateApiResponse.ReadOnly
          ] = proxy(CreateApi, request)
          def createVpcLink(request: CreateVpcLinkRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.CreateVpcLinkResponse.ReadOnly
          ] = proxy(CreateVpcLink, request)
          def updateApi(request: UpdateApiRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.UpdateApiResponse.ReadOnly
          ] = proxy(UpdateApi, request)
          def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
            proxy(UntagResource, request)
          def getAuthorizers(request: GetAuthorizersRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigatewayv2.model.Authorizer.ReadOnly
          ] = rts.unsafeRun(proxy(GetAuthorizers, request))
          def getAuthorizersPaginated(request: GetAuthorizersRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetAuthorizersResponse.ReadOnly
          ] = proxy(GetAuthorizersPaginated, request)
          def updateIntegrationResponse(
              request: UpdateIntegrationResponseRequest
          ): IO[
            AwsError,
            zio.aws.apigatewayv2.model.UpdateIntegrationResponseResponse.ReadOnly
          ] = proxy(UpdateIntegrationResponse, request)
          def createDeployment(request: CreateDeploymentRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.CreateDeploymentResponse.ReadOnly
          ] = proxy(CreateDeployment, request)
          def getRoute(request: GetRouteRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetRouteResponse.ReadOnly
          ] = proxy(GetRoute, request)
          def getModelTemplate(request: GetModelTemplateRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetModelTemplateResponse.ReadOnly
          ] = proxy(GetModelTemplate, request)
          def createStage(request: CreateStageRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.CreateStageResponse.ReadOnly
          ] = proxy(CreateStage, request)
          def getApiMapping(request: GetApiMappingRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetApiMappingResponse.ReadOnly
          ] = proxy(GetApiMapping, request)
          def createAuthorizer(request: CreateAuthorizerRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.CreateAuthorizerResponse.ReadOnly
          ] = proxy(CreateAuthorizer, request)
          def createRouteResponse(request: CreateRouteResponseRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.CreateRouteResponseResponse.ReadOnly
          ] = proxy(CreateRouteResponse, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def getIntegration(request: GetIntegrationRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetIntegrationResponse.ReadOnly
          ] = proxy(GetIntegration, request)
          def createIntegrationResponse(
              request: CreateIntegrationResponseRequest
          ): IO[
            AwsError,
            zio.aws.apigatewayv2.model.CreateIntegrationResponseResponse.ReadOnly
          ] = proxy(CreateIntegrationResponse, request)
          def getDeployments(request: GetDeploymentsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigatewayv2.model.Deployment.ReadOnly
          ] = rts.unsafeRun(proxy(GetDeployments, request))
          def getDeploymentsPaginated(request: GetDeploymentsRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetDeploymentsResponse.ReadOnly
          ] = proxy(GetDeploymentsPaginated, request)
          def updateApiMapping(request: UpdateApiMappingRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.UpdateApiMappingResponse.ReadOnly
          ] = proxy(UpdateApiMapping, request)
          def deleteAuthorizer(
              request: DeleteAuthorizerRequest
          ): IO[AwsError, Unit] = proxy(DeleteAuthorizer, request)
          def deleteIntegrationResponse(
              request: DeleteIntegrationResponseRequest
          ): IO[AwsError, Unit] = proxy(DeleteIntegrationResponse, request)
          def getIntegrationResponses(
              request: GetIntegrationResponsesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.apigatewayv2.model.IntegrationResponse.ReadOnly
          ] = rts.unsafeRun(proxy(GetIntegrationResponses, request))
          def getIntegrationResponsesPaginated(
              request: GetIntegrationResponsesRequest
          ): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetIntegrationResponsesResponse.ReadOnly
          ] = proxy(GetIntegrationResponsesPaginated, request)
          def updateIntegration(request: UpdateIntegrationRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.UpdateIntegrationResponse.ReadOnly
          ] = proxy(UpdateIntegration, request)
          def createIntegration(request: CreateIntegrationRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.CreateIntegrationResponse.ReadOnly
          ] = proxy(CreateIntegration, request)
          def getModels(
              request: GetModelsRequest
          ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Model.ReadOnly] =
            rts.unsafeRun(proxy(GetModels, request))
          def getModelsPaginated(request: GetModelsRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetModelsResponse.ReadOnly
          ] = proxy(GetModelsPaginated, request)
          def getStages(
              request: GetStagesRequest
          ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Stage.ReadOnly] =
            rts.unsafeRun(proxy(GetStages, request))
          def getStagesPaginated(request: GetStagesRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetStagesResponse.ReadOnly
          ] = proxy(GetStagesPaginated, request)
          def getDomainName(request: GetDomainNameRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetDomainNameResponse.ReadOnly
          ] = proxy(GetDomainName, request)
          def getIntegrations(request: GetIntegrationsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.apigatewayv2.model.Integration.ReadOnly
          ] = rts.unsafeRun(proxy(GetIntegrations, request))
          def getIntegrationsPaginated(request: GetIntegrationsRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetIntegrationsResponse.ReadOnly
          ] = proxy(GetIntegrationsPaginated, request)
          def getRoutes(
              request: GetRoutesRequest
          ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Route.ReadOnly] =
            rts.unsafeRun(proxy(GetRoutes, request))
          def getRoutesPaginated(request: GetRoutesRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetRoutesResponse.ReadOnly
          ] = proxy(GetRoutesPaginated, request)
          def getAuthorizer(request: GetAuthorizerRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.GetAuthorizerResponse.ReadOnly
          ] = proxy(GetAuthorizer, request)
          def deleteDomainName(
              request: DeleteDomainNameRequest
          ): IO[AwsError, Unit] = proxy(DeleteDomainName, request)
          def getApis(
              request: GetApisRequest
          ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Api.ReadOnly] =
            rts.unsafeRun(proxy(GetApis, request))
          def getApisPaginated(
              request: GetApisRequest
          ): IO[AwsError, zio.aws.apigatewayv2.model.GetApisResponse.ReadOnly] =
            proxy(GetApisPaginated, request)
          def deleteRouteResponse(
              request: DeleteRouteResponseRequest
          ): IO[AwsError, Unit] = proxy(DeleteRouteResponse, request)
          def updateDomainName(request: UpdateDomainNameRequest): IO[
            AwsError,
            zio.aws.apigatewayv2.model.UpdateDomainNameResponse.ReadOnly
          ] = proxy(UpdateDomainName, request)
          def getTags(
              request: GetTagsRequest
          ): IO[AwsError, zio.aws.apigatewayv2.model.GetTagsResponse.ReadOnly] =
            proxy(GetTags, request)
        }
      }
    }
    .toLayer
}
