package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And1600,
  __string,
  StringWithLengthBetween0And1024,
  __timestampIso8601,
  StringWithLengthBetween1And128,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetVpcLinkResponse(
    createdDate: Option[__timestampIso8601] = None,
    name: Option[StringWithLengthBetween1And128] = None,
    securityGroupIds: Option[Iterable[__string]] = None,
    subnetIds: Option[Iterable[__string]] = None,
    tags: Option[Map[__string, StringWithLengthBetween1And1600]] = None,
    vpcLinkId: Option[Id] = None,
    vpcLinkStatus: Option[zio.aws.apigatewayv2.model.VpcLinkStatus] = None,
    vpcLinkStatusMessage: Option[StringWithLengthBetween0And1024] = None,
    vpcLinkVersion: Option[zio.aws.apigatewayv2.model.VpcLinkVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinkResponse = {
    import GetVpcLinkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinkResponse
      .builder()
      .optionallyWith(createdDate.map(value => value: Instant))(_.createdDate)
      .optionallyWith(
        name.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And1600
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        vpcLinkId.map(value => Id.unwrap(value): java.lang.String)
      )(_.vpcLinkId)
      .optionallyWith(vpcLinkStatus.map(value => value.unwrap))(_.vpcLinkStatus)
      .optionallyWith(
        vpcLinkStatusMessage.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.vpcLinkStatusMessage)
      .optionallyWith(vpcLinkVersion.map(value => value.unwrap))(
        _.vpcLinkVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetVpcLinkResponse.ReadOnly =
    zio.aws.apigatewayv2.model.GetVpcLinkResponse.wrap(buildAwsValue())
}
object GetVpcLinkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetVpcLinkResponse =
      zio.aws.apigatewayv2.model.GetVpcLinkResponse(
        createdDate.map(value => value),
        name.map(value => value),
        securityGroupIds.map(value => value),
        subnetIds.map(value => value),
        tags.map(value => value),
        vpcLinkId.map(value => value),
        vpcLinkStatus.map(value => value),
        vpcLinkStatusMessage.map(value => value),
        vpcLinkVersion.map(value => value)
      )
    def createdDate: Option[__timestampIso8601]
    def name: Option[StringWithLengthBetween1And128]
    def securityGroupIds: Option[List[__string]]
    def subnetIds: Option[List[__string]]
    def tags: Option[Map[__string, StringWithLengthBetween1And1600]]
    def vpcLinkId: Option[Id]
    def vpcLinkStatus: Option[zio.aws.apigatewayv2.model.VpcLinkStatus]
    def vpcLinkStatusMessage: Option[StringWithLengthBetween0And1024]
    def vpcLinkVersion: Option[zio.aws.apigatewayv2.model.VpcLinkVersion]
    def getCreatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("name", name)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getTags
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And1600]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcLinkId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("vpcLinkId", vpcLinkId)
    def getVpcLinkStatus
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.VpcLinkStatus] =
      AwsError.unwrapOptionField("vpcLinkStatus", vpcLinkStatus)
    def getVpcLinkStatusMessage
        : ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("vpcLinkStatusMessage", vpcLinkStatusMessage)
    def getVpcLinkVersion
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.VpcLinkVersion] =
      AwsError.unwrapOptionField("vpcLinkVersion", vpcLinkVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinkResponse
  ) extends zio.aws.apigatewayv2.model.GetVpcLinkResponse.ReadOnly {
    override val createdDate: Option[__timestampIso8601] =
      scala.Option(impl.createdDate()).map(value => value: __timestampIso8601)
    override val name: Option[StringWithLengthBetween1And128] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And128(value)
      )
    override val securityGroupIds: Option[List[__string]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val subnetIds: Option[List[__string]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val tags: Option[Map[__string, StringWithLengthBetween1And1600]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And1600(value)
            })
            .toMap
        )
    override val vpcLinkId: Option[Id] = scala
      .Option(impl.vpcLinkId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val vpcLinkStatus
        : Option[zio.aws.apigatewayv2.model.VpcLinkStatus] = scala
      .Option(impl.vpcLinkStatus())
      .map(value => zio.aws.apigatewayv2.model.VpcLinkStatus.wrap(value))
    override val vpcLinkStatusMessage: Option[StringWithLengthBetween0And1024] =
      scala
        .Option(impl.vpcLinkStatusMessage())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween0And1024(value)
        )
    override val vpcLinkVersion
        : Option[zio.aws.apigatewayv2.model.VpcLinkVersion] = scala
      .Option(impl.vpcLinkVersion())
      .map(value => zio.aws.apigatewayv2.model.VpcLinkVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinkResponse
  ): zio.aws.apigatewayv2.model.GetVpcLinkResponse.ReadOnly = new Wrapper(impl)
}
