package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween0And2048,
  __string,
  __boolean,
  StringWithLengthBetween0And1024,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateStageRequest(
    accessLogSettings: Option[zio.aws.apigatewayv2.model.AccessLogSettings] =
      None,
    apiId: __string,
    autoDeploy: Option[__boolean] = None,
    clientCertificateId: Option[Id] = None,
    defaultRouteSettings: Option[zio.aws.apigatewayv2.model.RouteSettings] =
      None,
    deploymentId: Option[Id] = None,
    description: Option[StringWithLengthBetween0And1024] = None,
    routeSettings: Option[
      Map[__string, zio.aws.apigatewayv2.model.RouteSettings]
    ] = None,
    stageName: __string,
    stageVariables: Option[Map[__string, StringWithLengthBetween0And2048]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateStageRequest = {
    import UpdateStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateStageRequest
      .builder()
      .optionallyWith(accessLogSettings.map(value => value.buildAwsValue()))(
        _.accessLogSettings
      )
      .apiId(apiId: java.lang.String)
      .optionallyWith(autoDeploy.map(value => value: java.lang.Boolean))(
        _.autoDeploy
      )
      .optionallyWith(
        clientCertificateId.map(value => Id.unwrap(value): java.lang.String)
      )(_.clientCertificateId)
      .optionallyWith(defaultRouteSettings.map(value => value.buildAwsValue()))(
        _.defaultRouteSettings
      )
      .optionallyWith(
        deploymentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        routeSettings.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.routeSettings)
      .stageName(stageName: java.lang.String)
      .optionallyWith(
        stageVariables.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween0And2048
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.stageVariables)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateStageRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateStageRequest.wrap(buildAwsValue())
}
object UpdateStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateStageRequest =
      zio.aws.apigatewayv2.model.UpdateStageRequest(
        accessLogSettings.map(value => value.asEditable),
        apiId,
        autoDeploy.map(value => value),
        clientCertificateId.map(value => value),
        defaultRouteSettings.map(value => value.asEditable),
        deploymentId.map(value => value),
        description.map(value => value),
        routeSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        stageName,
        stageVariables.map(value => value)
      )
    def accessLogSettings
        : Option[zio.aws.apigatewayv2.model.AccessLogSettings.ReadOnly]
    def apiId: __string
    def autoDeploy: Option[__boolean]
    def clientCertificateId: Option[Id]
    def defaultRouteSettings
        : Option[zio.aws.apigatewayv2.model.RouteSettings.ReadOnly]
    def deploymentId: Option[Id]
    def description: Option[StringWithLengthBetween0And1024]
    def routeSettings: Option[
      Map[__string, zio.aws.apigatewayv2.model.RouteSettings.ReadOnly]
    ]
    def stageName: __string
    def stageVariables: Option[Map[__string, StringWithLengthBetween0And2048]]
    def getAccessLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.AccessLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogSettings", accessLogSettings)
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getAutoDeploy: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("autoDeploy", autoDeploy)
    def getClientCertificateId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getDefaultRouteSettings: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.RouteSettings.ReadOnly
    ] = AwsError.unwrapOptionField("defaultRouteSettings", defaultRouteSettings)
    def getDeploymentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getRouteSettings: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.apigatewayv2.model.RouteSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("routeSettings", routeSettings)
    def getStageName: ZIO[Any, Nothing, __string] = ZIO.succeed(stageName)
    def getStageVariables
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween0And2048]] =
      AwsError.unwrapOptionField("stageVariables", stageVariables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateStageRequest
  ) extends zio.aws.apigatewayv2.model.UpdateStageRequest.ReadOnly {
    override val accessLogSettings
        : Option[zio.aws.apigatewayv2.model.AccessLogSettings.ReadOnly] = scala
      .Option(impl.accessLogSettings())
      .map(value => zio.aws.apigatewayv2.model.AccessLogSettings.wrap(value))
    override val apiId: __string = impl.apiId(): __string
    override val autoDeploy: Option[__boolean] =
      scala.Option(impl.autoDeploy()).map(value => value: __boolean)
    override val clientCertificateId: Option[Id] = scala
      .Option(impl.clientCertificateId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val defaultRouteSettings
        : Option[zio.aws.apigatewayv2.model.RouteSettings.ReadOnly] = scala
      .Option(impl.defaultRouteSettings())
      .map(value => zio.aws.apigatewayv2.model.RouteSettings.wrap(value))
    override val deploymentId: Option[Id] = scala
      .Option(impl.deploymentId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val description: Option[StringWithLengthBetween0And1024] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween0And1024(value)
      )
    override val routeSettings: Option[
      Map[__string, zio.aws.apigatewayv2.model.RouteSettings.ReadOnly]
    ] = scala
      .Option(impl.routeSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.RouteSettings
              .wrap(value)
          })
          .toMap
      )
    override val stageName: __string = impl.stageName(): __string
    override val stageVariables
        : Option[Map[__string, StringWithLengthBetween0And2048]] = scala
      .Option(impl.stageVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween0And2048(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateStageRequest
  ): zio.aws.apigatewayv2.model.UpdateStageRequest.ReadOnly = new Wrapper(impl)
}
