package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And256,
  __string,
  StringWithLengthBetween0And1024,
  StringWithLengthBetween0And32K,
  StringWithLengthBetween1And128
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateModelRequest(
    apiId: __string,
    contentType: Option[StringWithLengthBetween1And256] = None,
    description: Option[StringWithLengthBetween0And1024] = None,
    name: StringWithLengthBetween1And128,
    schema: StringWithLengthBetween0And32K
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateModelRequest = {
    import CreateModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateModelRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(
        contentType.map(value =>
          StringWithLengthBetween1And256.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(StringWithLengthBetween1And128.unwrap(name): java.lang.String)
      .schema(StringWithLengthBetween0And32K.unwrap(schema): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateModelRequest.ReadOnly =
    zio.aws.apigatewayv2.model.CreateModelRequest.wrap(buildAwsValue())
}
object CreateModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateModelRequest =
      zio.aws.apigatewayv2.model.CreateModelRequest(
        apiId,
        contentType.map(value => value),
        description.map(value => value),
        name,
        schema
      )
    def apiId: __string
    def contentType: Option[StringWithLengthBetween1And256]
    def description: Option[StringWithLengthBetween0And1024]
    def name: StringWithLengthBetween1And128
    def schema: StringWithLengthBetween0And32K
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getContentType: ZIO[Any, AwsError, StringWithLengthBetween1And256] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, StringWithLengthBetween1And128] =
      ZIO.succeed(name)
    def getSchema: ZIO[Any, Nothing, StringWithLengthBetween0And32K] =
      ZIO.succeed(schema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateModelRequest
  ) extends zio.aws.apigatewayv2.model.CreateModelRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val contentType: Option[StringWithLengthBetween1And256] = scala
      .Option(impl.contentType())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And256(value)
      )
    override val description: Option[StringWithLengthBetween0And1024] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween0And1024(value)
      )
    override val name: StringWithLengthBetween1And128 =
      zio.aws.apigatewayv2.model.primitives
        .StringWithLengthBetween1And128(impl.name())
    override val schema: StringWithLengthBetween0And32K =
      zio.aws.apigatewayv2.model.primitives
        .StringWithLengthBetween0And32K(impl.schema())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateModelRequest
  ): zio.aws.apigatewayv2.model.CreateModelRequest.ReadOnly = new Wrapper(impl)
}
