package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  SelectionKey,
  SelectionExpression,
  StringWithLengthBetween1And512,
  StringWithLengthBetween0And32K
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateIntegrationResponseRequest(
    apiId: __string,
    contentHandlingStrategy: Option[
      zio.aws.apigatewayv2.model.ContentHandlingStrategy
    ] = None,
    integrationId: __string,
    integrationResponseId: __string,
    integrationResponseKey: Option[SelectionKey] = None,
    responseParameters: Option[Map[__string, StringWithLengthBetween1And512]] =
      None,
    responseTemplates: Option[Map[__string, StringWithLengthBetween0And32K]] =
      None,
    templateSelectionExpression: Option[SelectionExpression] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseRequest = {
    import UpdateIntegrationResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(contentHandlingStrategy.map(value => value.unwrap))(
        _.contentHandlingStrategy
      )
      .integrationId(integrationId: java.lang.String)
      .integrationResponseId(integrationResponseId: java.lang.String)
      .optionallyWith(
        integrationResponseKey.map(value =>
          SelectionKey.unwrap(value): java.lang.String
        )
      )(_.integrationResponseKey)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And512.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        responseTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween0And32K
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.responseTemplates)
      .optionallyWith(
        templateSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.templateSelectionExpression)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewayv2.model.UpdateIntegrationResponseRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateIntegrationResponseRequest
      .wrap(buildAwsValue())
}
object UpdateIntegrationResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apigatewayv2.model.UpdateIntegrationResponseRequest =
      zio.aws.apigatewayv2.model.UpdateIntegrationResponseRequest(
        apiId,
        contentHandlingStrategy.map(value => value),
        integrationId,
        integrationResponseId,
        integrationResponseKey.map(value => value),
        responseParameters.map(value => value),
        responseTemplates.map(value => value),
        templateSelectionExpression.map(value => value)
      )
    def apiId: __string
    def contentHandlingStrategy
        : Option[zio.aws.apigatewayv2.model.ContentHandlingStrategy]
    def integrationId: __string
    def integrationResponseId: __string
    def integrationResponseKey: Option[SelectionKey]
    def responseParameters
        : Option[Map[__string, StringWithLengthBetween1And512]]
    def responseTemplates: Option[Map[__string, StringWithLengthBetween0And32K]]
    def templateSelectionExpression: Option[SelectionExpression]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getContentHandlingStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.ContentHandlingStrategy
    ] = AwsError.unwrapOptionField(
      "contentHandlingStrategy",
      contentHandlingStrategy
    )
    def getIntegrationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(integrationId)
    def getIntegrationResponseId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(integrationResponseId)
    def getIntegrationResponseKey: ZIO[Any, AwsError, SelectionKey] = AwsError
      .unwrapOptionField("integrationResponseKey", integrationResponseKey)
    def getResponseParameters
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And512]] =
      AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getResponseTemplates
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween0And32K]] =
      AwsError.unwrapOptionField("responseTemplates", responseTemplates)
    def getTemplateSelectionExpression
        : ZIO[Any, AwsError, SelectionExpression] = AwsError.unwrapOptionField(
      "templateSelectionExpression",
      templateSelectionExpression
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseRequest
  ) extends zio.aws.apigatewayv2.model.UpdateIntegrationResponseRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val contentHandlingStrategy
        : Option[zio.aws.apigatewayv2.model.ContentHandlingStrategy] = scala
      .Option(impl.contentHandlingStrategy())
      .map(value =>
        zio.aws.apigatewayv2.model.ContentHandlingStrategy.wrap(value)
      )
    override val integrationId: __string = impl.integrationId(): __string
    override val integrationResponseId: __string =
      impl.integrationResponseId(): __string
    override val integrationResponseKey: Option[SelectionKey] = scala
      .Option(impl.integrationResponseKey())
      .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
    override val responseParameters
        : Option[Map[__string, StringWithLengthBetween1And512]] = scala
      .Option(impl.responseParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween1And512(value)
          })
          .toMap
      )
    override val responseTemplates
        : Option[Map[__string, StringWithLengthBetween0And32K]] = scala
      .Option(impl.responseTemplates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween0And32K(value)
          })
          .toMap
      )
    override val templateSelectionExpression: Option[SelectionExpression] =
      scala
        .Option(impl.templateSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseRequest
  ): zio.aws.apigatewayv2.model.UpdateIntegrationResponseRequest.ReadOnly =
    new Wrapper(impl)
}
