package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  SelectionKey,
  SelectionExpression,
  StringWithLengthBetween1And512,
  StringWithLengthBetween0And32K,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateIntegrationResponseResponse(
    contentHandlingStrategy: Option[
      zio.aws.apigatewayv2.model.ContentHandlingStrategy
    ] = None,
    integrationResponseId: Option[Id] = None,
    integrationResponseKey: Option[SelectionKey] = None,
    responseParameters: Option[Map[__string, StringWithLengthBetween1And512]] =
      None,
    responseTemplates: Option[Map[__string, StringWithLengthBetween0And32K]] =
      None,
    templateSelectionExpression: Option[SelectionExpression] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseResponse = {
    import UpdateIntegrationResponseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseResponse
      .builder()
      .optionallyWith(contentHandlingStrategy.map(value => value.unwrap))(
        _.contentHandlingStrategy
      )
      .optionallyWith(
        integrationResponseId.map(value => Id.unwrap(value): java.lang.String)
      )(_.integrationResponseId)
      .optionallyWith(
        integrationResponseKey.map(value =>
          SelectionKey.unwrap(value): java.lang.String
        )
      )(_.integrationResponseKey)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween1And512.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        responseTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween0And32K
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.responseTemplates)
      .optionallyWith(
        templateSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.templateSelectionExpression)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewayv2.model.UpdateIntegrationResponseResponse.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateIntegrationResponseResponse
      .wrap(buildAwsValue())
}
object UpdateIntegrationResponseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apigatewayv2.model.UpdateIntegrationResponseResponse =
      zio.aws.apigatewayv2.model.UpdateIntegrationResponseResponse(
        contentHandlingStrategy.map(value => value),
        integrationResponseId.map(value => value),
        integrationResponseKey.map(value => value),
        responseParameters.map(value => value),
        responseTemplates.map(value => value),
        templateSelectionExpression.map(value => value)
      )
    def contentHandlingStrategy
        : Option[zio.aws.apigatewayv2.model.ContentHandlingStrategy]
    def integrationResponseId: Option[Id]
    def integrationResponseKey: Option[SelectionKey]
    def responseParameters
        : Option[Map[__string, StringWithLengthBetween1And512]]
    def responseTemplates: Option[Map[__string, StringWithLengthBetween0And32K]]
    def templateSelectionExpression: Option[SelectionExpression]
    def getContentHandlingStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.ContentHandlingStrategy
    ] = AwsError.unwrapOptionField(
      "contentHandlingStrategy",
      contentHandlingStrategy
    )
    def getIntegrationResponseId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("integrationResponseId", integrationResponseId)
    def getIntegrationResponseKey: ZIO[Any, AwsError, SelectionKey] = AwsError
      .unwrapOptionField("integrationResponseKey", integrationResponseKey)
    def getResponseParameters
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And512]] =
      AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getResponseTemplates
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween0And32K]] =
      AwsError.unwrapOptionField("responseTemplates", responseTemplates)
    def getTemplateSelectionExpression
        : ZIO[Any, AwsError, SelectionExpression] = AwsError.unwrapOptionField(
      "templateSelectionExpression",
      templateSelectionExpression
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseResponse
  ) extends zio.aws.apigatewayv2.model.UpdateIntegrationResponseResponse.ReadOnly {
    override val contentHandlingStrategy
        : Option[zio.aws.apigatewayv2.model.ContentHandlingStrategy] = scala
      .Option(impl.contentHandlingStrategy())
      .map(value =>
        zio.aws.apigatewayv2.model.ContentHandlingStrategy.wrap(value)
      )
    override val integrationResponseId: Option[Id] = scala
      .Option(impl.integrationResponseId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val integrationResponseKey: Option[SelectionKey] = scala
      .Option(impl.integrationResponseKey())
      .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
    override val responseParameters
        : Option[Map[__string, StringWithLengthBetween1And512]] = scala
      .Option(impl.responseParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.apigatewayv2.model.primitives
              .__string(key) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween1And512(value)
          })
          .toMap
      )
    override val responseTemplates
        : Option[Map[__string, StringWithLengthBetween0And32K]] = scala
      .Option(impl.responseTemplates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.apigatewayv2.model.primitives
              .__string(key) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween0And32K(value)
          })
          .toMap
      )
    override val templateSelectionExpression: Option[SelectionExpression] =
      scala
        .Option(impl.templateSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateIntegrationResponseResponse
  ): zio.aws.apigatewayv2.model.UpdateIntegrationResponseResponse.ReadOnly =
    new Wrapper(impl)
}
