package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.StringWithLengthBetween1And512
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TlsConfig(
    serverNameToVerify: Option[StringWithLengthBetween1And512] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.TlsConfig = {
    import TlsConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.TlsConfig
      .builder()
      .optionallyWith(
        serverNameToVerify.map(value =>
          StringWithLengthBetween1And512.unwrap(value): java.lang.String
        )
      )(_.serverNameToVerify)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.TlsConfig.ReadOnly =
    zio.aws.apigatewayv2.model.TlsConfig.wrap(buildAwsValue())
}
object TlsConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.TlsConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.TlsConfig =
      zio.aws.apigatewayv2.model
        .TlsConfig(serverNameToVerify.map(value => value))
    def serverNameToVerify: Option[StringWithLengthBetween1And512]
    def getServerNameToVerify
        : ZIO[Any, AwsError, StringWithLengthBetween1And512] =
      AwsError.unwrapOptionField("serverNameToVerify", serverNameToVerify)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.TlsConfig
  ) extends zio.aws.apigatewayv2.model.TlsConfig.ReadOnly {
    override val serverNameToVerify: Option[StringWithLengthBetween1And512] =
      scala
        .Option(impl.serverNameToVerify())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And512(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.TlsConfig
  ): zio.aws.apigatewayv2.model.TlsConfig.ReadOnly = new Wrapper(impl)
}
