package zio.aws.apigatewayv2.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectionType {
  def unwrap: software.amazon.awssdk.services.apigatewayv2.model.ConnectionType
}
object ConnectionType {
  def wrap(
      value: software.amazon.awssdk.services.apigatewayv2.model.ConnectionType
  ): zio.aws.apigatewayv2.model.ConnectionType = value match {
    case software.amazon.awssdk.services.apigatewayv2.model.ConnectionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigatewayv2.model.ConnectionType.INTERNET =>
      val r = INTERNET
      r
    case software.amazon.awssdk.services.apigatewayv2.model.ConnectionType.VPC_LINK =>
      val r = VPC_LINK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigatewayv2.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.ConnectionType =
      software.amazon.awssdk.services.apigatewayv2.model.ConnectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNET extends zio.aws.apigatewayv2.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.ConnectionType =
      software.amazon.awssdk.services.apigatewayv2.model.ConnectionType.INTERNET
  }
  case object VPC_LINK extends zio.aws.apigatewayv2.model.ConnectionType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.ConnectionType =
      software.amazon.awssdk.services.apigatewayv2.model.ConnectionType.VPC_LINK
  }
}
