package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And1600,
  __string,
  StringWithLengthBetween1And512
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDomainNameRequest(
    domainName: StringWithLengthBetween1And512,
    domainNameConfigurations: Option[
      Iterable[zio.aws.apigatewayv2.model.DomainNameConfiguration]
    ] = None,
    mutualTlsAuthentication: Option[
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput
    ] = None,
    tags: Option[Map[__string, StringWithLengthBetween1And1600]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest = {
    import CreateDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest
      .builder()
      .domainName(
        StringWithLengthBetween1And512.unwrap(domainName): java.lang.String
      )
      .optionallyWith(
        domainNameConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainNameConfigurations)
      .optionallyWith(
        mutualTlsAuthentication.map(value => value.buildAwsValue())
      )(_.mutualTlsAuthentication)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween1And1600
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateDomainNameRequest.ReadOnly =
    zio.aws.apigatewayv2.model.CreateDomainNameRequest.wrap(buildAwsValue())
}
object CreateDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateDomainNameRequest =
      zio.aws.apigatewayv2.model.CreateDomainNameRequest(
        domainName,
        domainNameConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mutualTlsAuthentication.map(value => value.asEditable),
        tags.map(value => value)
      )
    def domainName: StringWithLengthBetween1And512
    def domainNameConfigurations: Option[
      List[zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly]
    ]
    def mutualTlsAuthentication: Option[
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly
    ]
    def tags: Option[Map[__string, StringWithLengthBetween1And1600]]
    def getDomainName: ZIO[Any, Nothing, StringWithLengthBetween1And512] =
      ZIO.succeed(domainName)
    def getDomainNameConfigurations: ZIO[Any, AwsError, List[
      zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainNameConfigurations",
      domainNameConfigurations
    )
    def getMutualTlsAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mutualTlsAuthentication",
      mutualTlsAuthentication
    )
    def getTags
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And1600]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest
  ) extends zio.aws.apigatewayv2.model.CreateDomainNameRequest.ReadOnly {
    override val domainName: StringWithLengthBetween1And512 =
      zio.aws.apigatewayv2.model.primitives
        .StringWithLengthBetween1And512(impl.domainName())
    override val domainNameConfigurations: Option[
      List[zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly]
    ] = scala
      .Option(impl.domainNameConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.DomainNameConfiguration.wrap(item)
        }.toList
      )
    override val mutualTlsAuthentication: Option[
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly
    ] = scala
      .Option(impl.mutualTlsAuthentication())
      .map(value =>
        zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.wrap(value)
      )
    override val tags: Option[Map[__string, StringWithLengthBetween1And1600]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.apigatewayv2.model.primitives
                .__string(key) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And1600(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest
  ): zio.aws.apigatewayv2.model.CreateDomainNameRequest.ReadOnly = new Wrapper(
    impl
  )
}
