package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And1600,
  __string,
  StringWithLengthBetween0And1024,
  __timestampIso8601,
  StringWithLengthBetween1And128,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class VpcLink(
    createdDate: Option[__timestampIso8601] = None,
    name: StringWithLengthBetween1And128,
    securityGroupIds: Iterable[__string],
    subnetIds: Iterable[__string],
    tags: Option[Map[__string, StringWithLengthBetween1And1600]] = None,
    vpcLinkId: Id,
    vpcLinkStatus: Option[zio.aws.apigatewayv2.model.VpcLinkStatus] = None,
    vpcLinkStatusMessage: Option[StringWithLengthBetween0And1024] = None,
    vpcLinkVersion: Option[zio.aws.apigatewayv2.model.VpcLinkVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.VpcLink = {
    import VpcLink.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.VpcLink
      .builder()
      .optionallyWith(
        createdDate.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.createdDate)
      .name(StringWithLengthBetween1And128.unwrap(name): java.lang.String)
      .securityGroupIds(securityGroupIds.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .subnetIds(subnetIds.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween1And1600.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .vpcLinkId(Id.unwrap(vpcLinkId): java.lang.String)
      .optionallyWith(vpcLinkStatus.map(value => value.unwrap))(_.vpcLinkStatus)
      .optionallyWith(
        vpcLinkStatusMessage.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.vpcLinkStatusMessage)
      .optionallyWith(vpcLinkVersion.map(value => value.unwrap))(
        _.vpcLinkVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.VpcLink.ReadOnly =
    zio.aws.apigatewayv2.model.VpcLink.wrap(buildAwsValue())
}
object VpcLink {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.VpcLink
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.VpcLink =
      zio.aws.apigatewayv2.model.VpcLink(
        createdDate.map(value => value),
        name,
        securityGroupIds,
        subnetIds,
        tags.map(value => value),
        vpcLinkId,
        vpcLinkStatus.map(value => value),
        vpcLinkStatusMessage.map(value => value),
        vpcLinkVersion.map(value => value)
      )
    def createdDate: Option[__timestampIso8601]
    def name: StringWithLengthBetween1And128
    def securityGroupIds: List[__string]
    def subnetIds: List[__string]
    def tags: Option[Map[__string, StringWithLengthBetween1And1600]]
    def vpcLinkId: Id
    def vpcLinkStatus: Option[zio.aws.apigatewayv2.model.VpcLinkStatus]
    def vpcLinkStatusMessage: Option[StringWithLengthBetween0And1024]
    def vpcLinkVersion: Option[zio.aws.apigatewayv2.model.VpcLinkVersion]
    def getCreatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getName: ZIO[Any, Nothing, StringWithLengthBetween1And128] =
      ZIO.succeed(name)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(securityGroupIds)
    def getSubnetIds: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(subnetIds)
    def getTags
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And1600]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcLinkId: ZIO[Any, Nothing, Id] = ZIO.succeed(vpcLinkId)
    def getVpcLinkStatus
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.VpcLinkStatus] =
      AwsError.unwrapOptionField("vpcLinkStatus", vpcLinkStatus)
    def getVpcLinkStatusMessage
        : ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("vpcLinkStatusMessage", vpcLinkStatusMessage)
    def getVpcLinkVersion
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.VpcLinkVersion] =
      AwsError.unwrapOptionField("vpcLinkVersion", vpcLinkVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.VpcLink
  ) extends zio.aws.apigatewayv2.model.VpcLink.ReadOnly {
    override val createdDate: Option[__timestampIso8601] = scala
      .Option(impl.createdDate())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.__timestampIso8601(value)
      )
    override val name: StringWithLengthBetween1And128 =
      zio.aws.apigatewayv2.model.primitives
        .StringWithLengthBetween1And128(impl.name())
    override val securityGroupIds: List[__string] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.apigatewayv2.model.primitives.__string(item)
      }
      .toList
    override val subnetIds: List[__string] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.apigatewayv2.model.primitives.__string(item)
      }
      .toList
    override val tags: Option[Map[__string, StringWithLengthBetween1And1600]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.apigatewayv2.model.primitives
                .__string(key) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And1600(value)
            })
            .toMap
        )
    override val vpcLinkId: Id =
      zio.aws.apigatewayv2.model.primitives.Id(impl.vpcLinkId())
    override val vpcLinkStatus
        : Option[zio.aws.apigatewayv2.model.VpcLinkStatus] = scala
      .Option(impl.vpcLinkStatus())
      .map(value => zio.aws.apigatewayv2.model.VpcLinkStatus.wrap(value))
    override val vpcLinkStatusMessage: Option[StringWithLengthBetween0And1024] =
      scala
        .Option(impl.vpcLinkStatusMessage())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween0And1024(value)
        )
    override val vpcLinkVersion
        : Option[zio.aws.apigatewayv2.model.VpcLinkVersion] = scala
      .Option(impl.vpcLinkVersion())
      .map(value => zio.aws.apigatewayv2.model.VpcLinkVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.VpcLink
  ): zio.aws.apigatewayv2.model.VpcLink.ReadOnly = new Wrapper(impl)
}
