package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And1600,
  __string,
  __boolean,
  StringWithLengthBetween1And64,
  StringWithLengthBetween0And1024,
  SelectionExpression,
  __timestampIso8601,
  StringWithLengthBetween1And128,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateApiResponse(
    apiEndpoint: Option[__string] = None,
    apiGatewayManaged: Option[__boolean] = None,
    apiId: Option[Id] = None,
    apiKeySelectionExpression: Option[SelectionExpression] = None,
    corsConfiguration: Option[zio.aws.apigatewayv2.model.Cors] = None,
    createdDate: Option[__timestampIso8601] = None,
    description: Option[StringWithLengthBetween0And1024] = None,
    disableSchemaValidation: Option[__boolean] = None,
    disableExecuteApiEndpoint: Option[__boolean] = None,
    importInfo: Option[Iterable[__string]] = None,
    name: Option[StringWithLengthBetween1And128] = None,
    protocolType: Option[zio.aws.apigatewayv2.model.ProtocolType] = None,
    routeSelectionExpression: Option[SelectionExpression] = None,
    tags: Option[Map[__string, StringWithLengthBetween1And1600]] = None,
    version: Option[StringWithLengthBetween1And64] = None,
    warnings: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateApiResponse = {
    import CreateApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateApiResponse
      .builder()
      .optionallyWith(
        apiEndpoint.map(value => __string.unwrap(value): java.lang.String)
      )(_.apiEndpoint)
      .optionallyWith(
        apiGatewayManaged.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.apiGatewayManaged)
      .optionallyWith(apiId.map(value => Id.unwrap(value): java.lang.String))(
        _.apiId
      )
      .optionallyWith(
        apiKeySelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.apiKeySelectionExpression)
      .optionallyWith(corsConfiguration.map(value => value.buildAwsValue()))(
        _.corsConfiguration
      )
      .optionallyWith(
        createdDate.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        disableSchemaValidation.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.disableSchemaValidation)
      .optionallyWith(
        disableExecuteApiEndpoint.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.disableExecuteApiEndpoint)
      .optionallyWith(
        importInfo.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.importInfo)
      .optionallyWith(
        name.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(protocolType.map(value => value.unwrap))(_.protocolType)
      .optionallyWith(
        routeSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.routeSelectionExpression)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween1And1600.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        version.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.version)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.warnings)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateApiResponse.ReadOnly =
    zio.aws.apigatewayv2.model.CreateApiResponse.wrap(buildAwsValue())
}
object CreateApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateApiResponse =
      zio.aws.apigatewayv2.model.CreateApiResponse(
        apiEndpoint.map(value => value),
        apiGatewayManaged.map(value => value),
        apiId.map(value => value),
        apiKeySelectionExpression.map(value => value),
        corsConfiguration.map(value => value.asEditable),
        createdDate.map(value => value),
        description.map(value => value),
        disableSchemaValidation.map(value => value),
        disableExecuteApiEndpoint.map(value => value),
        importInfo.map(value => value),
        name.map(value => value),
        protocolType.map(value => value),
        routeSelectionExpression.map(value => value),
        tags.map(value => value),
        version.map(value => value),
        warnings.map(value => value)
      )
    def apiEndpoint: Option[__string]
    def apiGatewayManaged: Option[__boolean]
    def apiId: Option[Id]
    def apiKeySelectionExpression: Option[SelectionExpression]
    def corsConfiguration: Option[zio.aws.apigatewayv2.model.Cors.ReadOnly]
    def createdDate: Option[__timestampIso8601]
    def description: Option[StringWithLengthBetween0And1024]
    def disableSchemaValidation: Option[__boolean]
    def disableExecuteApiEndpoint: Option[__boolean]
    def importInfo: Option[List[__string]]
    def name: Option[StringWithLengthBetween1And128]
    def protocolType: Option[zio.aws.apigatewayv2.model.ProtocolType]
    def routeSelectionExpression: Option[SelectionExpression]
    def tags: Option[Map[__string, StringWithLengthBetween1And1600]]
    def version: Option[StringWithLengthBetween1And64]
    def warnings: Option[List[__string]]
    def getApiEndpoint: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiEndpoint", apiEndpoint)
    def getApiGatewayManaged: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("apiGatewayManaged", apiGatewayManaged)
    def getApiId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getApiKeySelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "apiKeySelectionExpression",
        apiKeySelectionExpression
      )
    def getCorsConfiguration
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.Cors.ReadOnly] =
      AwsError.unwrapOptionField("corsConfiguration", corsConfiguration)
    def getCreatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getDisableSchemaValidation: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("disableSchemaValidation", disableSchemaValidation)
    def getDisableExecuteApiEndpoint: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("disableExecuteApiEndpoint", disableExecuteApiEndpoint)
    def getImportInfo: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("importInfo", importInfo)
    def getName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("name", name)
    def getProtocolType
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.ProtocolType] =
      AwsError.unwrapOptionField("protocolType", protocolType)
    def getRouteSelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "routeSelectionExpression",
        routeSelectionExpression
      )
    def getTags
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And1600]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVersion: ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("version", version)
    def getWarnings: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("warnings", warnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateApiResponse
  ) extends zio.aws.apigatewayv2.model.CreateApiResponse.ReadOnly {
    override val apiEndpoint: Option[__string] = scala
      .Option(impl.apiEndpoint())
      .map(value => zio.aws.apigatewayv2.model.primitives.__string(value))
    override val apiGatewayManaged: Option[__boolean] = scala
      .Option(impl.apiGatewayManaged())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
    override val apiId: Option[Id] = scala
      .Option(impl.apiId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val apiKeySelectionExpression: Option[SelectionExpression] = scala
      .Option(impl.apiKeySelectionExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
      )
    override val corsConfiguration
        : Option[zio.aws.apigatewayv2.model.Cors.ReadOnly] = scala
      .Option(impl.corsConfiguration())
      .map(value => zio.aws.apigatewayv2.model.Cors.wrap(value))
    override val createdDate: Option[__timestampIso8601] = scala
      .Option(impl.createdDate())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.__timestampIso8601(value)
      )
    override val description: Option[StringWithLengthBetween0And1024] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween0And1024(value)
      )
    override val disableSchemaValidation: Option[__boolean] = scala
      .Option(impl.disableSchemaValidation())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
    override val disableExecuteApiEndpoint: Option[__boolean] = scala
      .Option(impl.disableExecuteApiEndpoint())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
    override val importInfo: Option[List[__string]] = scala
      .Option(impl.importInfo())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.primitives.__string(item)
        }.toList
      )
    override val name: Option[StringWithLengthBetween1And128] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And128(value)
      )
    override val protocolType: Option[zio.aws.apigatewayv2.model.ProtocolType] =
      scala
        .Option(impl.protocolType())
        .map(value => zio.aws.apigatewayv2.model.ProtocolType.wrap(value))
    override val routeSelectionExpression: Option[SelectionExpression] = scala
      .Option(impl.routeSelectionExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
      )
    override val tags: Option[Map[__string, StringWithLengthBetween1And1600]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.apigatewayv2.model.primitives
                .__string(key) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And1600(value)
            })
            .toMap
        )
    override val version: Option[StringWithLengthBetween1And64] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And64(value)
      )
    override val warnings: Option[List[__string]] = scala
      .Option(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateApiResponse
  ): zio.aws.apigatewayv2.model.CreateApiResponse.ReadOnly = new Wrapper(impl)
}
