package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And128,
  __string,
  SelectionKey,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateApiMappingRequest(
    apiId: Id,
    apiMappingKey: Option[SelectionKey] = None,
    domainName: __string,
    stage: StringWithLengthBetween1And128
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingRequest = {
    import CreateApiMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingRequest
      .builder()
      .apiId(Id.unwrap(apiId): java.lang.String)
      .optionallyWith(
        apiMappingKey.map(value => SelectionKey.unwrap(value): java.lang.String)
      )(_.apiMappingKey)
      .domainName(__string.unwrap(domainName): java.lang.String)
      .stage(StringWithLengthBetween1And128.unwrap(stage): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateApiMappingRequest.ReadOnly =
    zio.aws.apigatewayv2.model.CreateApiMappingRequest.wrap(buildAwsValue())
}
object CreateApiMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateApiMappingRequest =
      zio.aws.apigatewayv2.model.CreateApiMappingRequest(
        apiId,
        apiMappingKey.map(value => value),
        domainName,
        stage
      )
    def apiId: Id
    def apiMappingKey: Option[SelectionKey]
    def domainName: __string
    def stage: StringWithLengthBetween1And128
    def getApiId: ZIO[Any, Nothing, Id] = ZIO.succeed(apiId)
    def getApiMappingKey: ZIO[Any, AwsError, SelectionKey] =
      AwsError.unwrapOptionField("apiMappingKey", apiMappingKey)
    def getDomainName: ZIO[Any, Nothing, __string] = ZIO.succeed(domainName)
    def getStage: ZIO[Any, Nothing, StringWithLengthBetween1And128] =
      ZIO.succeed(stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingRequest
  ) extends zio.aws.apigatewayv2.model.CreateApiMappingRequest.ReadOnly {
    override val apiId: Id =
      zio.aws.apigatewayv2.model.primitives.Id(impl.apiId())
    override val apiMappingKey: Option[SelectionKey] = scala
      .Option(impl.apiMappingKey())
      .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
    override val domainName: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.domainName())
    override val stage: StringWithLengthBetween1And128 =
      zio.aws.apigatewayv2.model.primitives
        .StringWithLengthBetween1And128(impl.stage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingRequest
  ): zio.aws.apigatewayv2.model.CreateApiMappingRequest.ReadOnly = new Wrapper(
    impl
  )
}
