package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRouteRequest(apiId: __string, routeId: __string) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequest = {
    import DeleteRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequest
      .builder()
      .apiId(__string.unwrap(apiId): java.lang.String)
      .routeId(__string.unwrap(routeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.DeleteRouteRequest.ReadOnly =
    zio.aws.apigatewayv2.model.DeleteRouteRequest.wrap(buildAwsValue())
}
object DeleteRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.DeleteRouteRequest =
      zio.aws.apigatewayv2.model.DeleteRouteRequest(apiId, routeId)
    def apiId: __string
    def routeId: __string
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getRouteId: ZIO[Any, Nothing, __string] = ZIO.succeed(routeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequest
  ) extends zio.aws.apigatewayv2.model.DeleteRouteRequest.ReadOnly {
    override val apiId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiId())
    override val routeId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.routeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequest
  ): zio.aws.apigatewayv2.model.DeleteRouteRequest.ReadOnly = new Wrapper(impl)
}
