package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And256,
  StringWithLengthBetween0And1024,
  StringWithLengthBetween0And32K,
  StringWithLengthBetween1And128,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateModelResponse(
    contentType: Option[StringWithLengthBetween1And256] = None,
    description: Option[StringWithLengthBetween0And1024] = None,
    modelId: Option[Id] = None,
    name: Option[StringWithLengthBetween1And128] = None,
    schema: Option[StringWithLengthBetween0And32K] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateModelResponse = {
    import CreateModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateModelResponse
      .builder()
      .optionallyWith(
        contentType.map(value =>
          StringWithLengthBetween1And256.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(modelId.map(value => Id.unwrap(value): java.lang.String))(
        _.modelId
      )
      .optionallyWith(
        name.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        schema.map(value =>
          StringWithLengthBetween0And32K.unwrap(value): java.lang.String
        )
      )(_.schema)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateModelResponse.ReadOnly =
    zio.aws.apigatewayv2.model.CreateModelResponse.wrap(buildAwsValue())
}
object CreateModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateModelResponse =
      zio.aws.apigatewayv2.model.CreateModelResponse(
        contentType.map(value => value),
        description.map(value => value),
        modelId.map(value => value),
        name.map(value => value),
        schema.map(value => value)
      )
    def contentType: Option[StringWithLengthBetween1And256]
    def description: Option[StringWithLengthBetween0And1024]
    def modelId: Option[Id]
    def name: Option[StringWithLengthBetween1And128]
    def schema: Option[StringWithLengthBetween0And32K]
    def getContentType: ZIO[Any, AwsError, StringWithLengthBetween1And256] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getModelId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("modelId", modelId)
    def getName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("name", name)
    def getSchema: ZIO[Any, AwsError, StringWithLengthBetween0And32K] =
      AwsError.unwrapOptionField("schema", schema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateModelResponse
  ) extends zio.aws.apigatewayv2.model.CreateModelResponse.ReadOnly {
    override val contentType: Option[StringWithLengthBetween1And256] = scala
      .Option(impl.contentType())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And256(value)
      )
    override val description: Option[StringWithLengthBetween0And1024] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween0And1024(value)
      )
    override val modelId: Option[Id] = scala
      .Option(impl.modelId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val name: Option[StringWithLengthBetween1And128] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And128(value)
      )
    override val schema: Option[StringWithLengthBetween0And32K] = scala
      .Option(impl.schema())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween0And32K(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateModelResponse
  ): zio.aws.apigatewayv2.model.CreateModelResponse.ReadOnly = new Wrapper(impl)
}
