package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRouteResponsesRequest(
    apiId: __string,
    maxResults: Option[__string] = None,
    nextToken: Option[__string] = None,
    routeId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest = {
    import GetRouteResponsesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest
      .builder()
      .apiId(__string.unwrap(apiId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => __string.unwrap(value): java.lang.String)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .routeId(__string.unwrap(routeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetRouteResponsesRequest.ReadOnly =
    zio.aws.apigatewayv2.model.GetRouteResponsesRequest.wrap(buildAwsValue())
}
object GetRouteResponsesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetRouteResponsesRequest =
      zio.aws.apigatewayv2.model.GetRouteResponsesRequest(
        apiId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        routeId
      )
    def apiId: __string
    def maxResults: Option[__string]
    def nextToken: Option[__string]
    def routeId: __string
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getMaxResults: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRouteId: ZIO[Any, Nothing, __string] = ZIO.succeed(routeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest
  ) extends zio.aws.apigatewayv2.model.GetRouteResponsesRequest.ReadOnly {
    override val apiId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiId())
    override val maxResults: Option[__string] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.apigatewayv2.model.primitives.__string(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.apigatewayv2.model.primitives.__string(value))
    override val routeId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.routeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest
  ): zio.aws.apigatewayv2.model.GetRouteResponsesRequest.ReadOnly = new Wrapper(
    impl
  )
}
