package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRouteResponseRequest(
    apiId: __string,
    routeId: __string,
    routeResponseId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponseRequest = {
    import DeleteRouteResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponseRequest
      .builder()
      .apiId(__string.unwrap(apiId): java.lang.String)
      .routeId(__string.unwrap(routeId): java.lang.String)
      .routeResponseId(__string.unwrap(routeResponseId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewayv2.model.DeleteRouteResponseRequest.ReadOnly =
    zio.aws.apigatewayv2.model.DeleteRouteResponseRequest.wrap(buildAwsValue())
}
object DeleteRouteResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.DeleteRouteResponseRequest =
      zio.aws.apigatewayv2.model
        .DeleteRouteResponseRequest(apiId, routeId, routeResponseId)
    def apiId: __string
    def routeId: __string
    def routeResponseId: __string
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getRouteId: ZIO[Any, Nothing, __string] = ZIO.succeed(routeId)
    def getRouteResponseId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(routeResponseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponseRequest
  ) extends zio.aws.apigatewayv2.model.DeleteRouteResponseRequest.ReadOnly {
    override val apiId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiId())
    override val routeId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.routeId())
    override val routeResponseId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.routeResponseId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteResponseRequest
  ): zio.aws.apigatewayv2.model.DeleteRouteResponseRequest.ReadOnly =
    new Wrapper(impl)
}
