package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDomainNameRequest(
    domainName: __string,
    domainNameConfigurations: Option[
      Iterable[zio.aws.apigatewayv2.model.DomainNameConfiguration]
    ] = None,
    mutualTlsAuthentication: Option[
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest = {
    import UpdateDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest
      .builder()
      .domainName(__string.unwrap(domainName): java.lang.String)
      .optionallyWith(
        domainNameConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainNameConfigurations)
      .optionallyWith(
        mutualTlsAuthentication.map(value => value.buildAwsValue())
      )(_.mutualTlsAuthentication)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateDomainNameRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateDomainNameRequest.wrap(buildAwsValue())
}
object UpdateDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateDomainNameRequest =
      zio.aws.apigatewayv2.model.UpdateDomainNameRequest(
        domainName,
        domainNameConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mutualTlsAuthentication.map(value => value.asEditable)
      )
    def domainName: __string
    def domainNameConfigurations: Option[
      List[zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly]
    ]
    def mutualTlsAuthentication: Option[
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly
    ]
    def getDomainName: ZIO[Any, Nothing, __string] = ZIO.succeed(domainName)
    def getDomainNameConfigurations: ZIO[Any, AwsError, List[
      zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainNameConfigurations",
      domainNameConfigurations
    )
    def getMutualTlsAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mutualTlsAuthentication",
      mutualTlsAuthentication
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest
  ) extends zio.aws.apigatewayv2.model.UpdateDomainNameRequest.ReadOnly {
    override val domainName: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.domainName())
    override val domainNameConfigurations: Option[
      List[zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly]
    ] = scala
      .Option(impl.domainNameConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.DomainNameConfiguration.wrap(item)
        }.toList
      )
    override val mutualTlsAuthentication: Option[
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly
    ] = scala
      .Option(impl.mutualTlsAuthentication())
      .map(value =>
        zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest
  ): zio.aws.apigatewayv2.model.UpdateDomainNameRequest.ReadOnly = new Wrapper(
    impl
  )
}
