package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRouteResponsesResponse(
    items: Option[Iterable[zio.aws.apigatewayv2.model.RouteResponse]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesResponse = {
    import GetRouteResponsesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewayv2.model.GetRouteResponsesResponse.ReadOnly =
    zio.aws.apigatewayv2.model.GetRouteResponsesResponse.wrap(buildAwsValue())
}
object GetRouteResponsesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetRouteResponsesResponse =
      zio.aws.apigatewayv2.model.GetRouteResponsesResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[List[zio.aws.apigatewayv2.model.RouteResponse.ReadOnly]]
    def nextToken: Option[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.apigatewayv2.model.RouteResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesResponse
  ) extends zio.aws.apigatewayv2.model.GetRouteResponsesResponse.ReadOnly {
    override val items
        : Option[List[zio.aws.apigatewayv2.model.RouteResponse.ReadOnly]] =
      scala
        .Option(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigatewayv2.model.RouteResponse.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.apigatewayv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesResponse
  ): zio.aws.apigatewayv2.model.GetRouteResponsesResponse.ReadOnly =
    new Wrapper(impl)
}
