package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And1600,
  __string,
  StringWithLengthBetween1And128
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateVpcLinkRequest(
    name: StringWithLengthBetween1And128,
    securityGroupIds: Option[Iterable[__string]] = None,
    subnetIds: Iterable[__string],
    tags: Option[Map[__string, StringWithLengthBetween1And1600]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateVpcLinkRequest = {
    import CreateVpcLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateVpcLinkRequest
      .builder()
      .name(StringWithLengthBetween1And128.unwrap(name): java.lang.String)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .subnetIds(subnetIds.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween1And1600
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateVpcLinkRequest.ReadOnly =
    zio.aws.apigatewayv2.model.CreateVpcLinkRequest.wrap(buildAwsValue())
}
object CreateVpcLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateVpcLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateVpcLinkRequest =
      zio.aws.apigatewayv2.model.CreateVpcLinkRequest(
        name,
        securityGroupIds.map(value => value),
        subnetIds,
        tags.map(value => value)
      )
    def name: StringWithLengthBetween1And128
    def securityGroupIds: Option[List[__string]]
    def subnetIds: List[__string]
    def tags: Option[Map[__string, StringWithLengthBetween1And1600]]
    def getName: ZIO[Any, Nothing, StringWithLengthBetween1And128] =
      ZIO.succeed(name)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(subnetIds)
    def getTags
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And1600]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateVpcLinkRequest
  ) extends zio.aws.apigatewayv2.model.CreateVpcLinkRequest.ReadOnly {
    override val name: StringWithLengthBetween1And128 =
      zio.aws.apigatewayv2.model.primitives
        .StringWithLengthBetween1And128(impl.name())
    override val securityGroupIds: Option[List[__string]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.primitives.__string(item)
        }.toList
      )
    override val subnetIds: List[__string] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.apigatewayv2.model.primitives.__string(item)
      }
      .toList
    override val tags: Option[Map[__string, StringWithLengthBetween1And1600]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.apigatewayv2.model.primitives
                .__string(key) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And1600(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateVpcLinkRequest
  ): zio.aws.apigatewayv2.model.CreateVpcLinkRequest.ReadOnly = new Wrapper(
    impl
  )
}
