package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  SelectionKey,
  StringWithLengthBetween1And128,
  SelectionExpression,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRouteResponseRequest(
    apiId: __string,
    modelSelectionExpression: Option[SelectionExpression] = None,
    responseModels: Option[Map[__string, StringWithLengthBetween1And128]] =
      None,
    responseParameters: Option[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints]
    ] = None,
    routeId: __string,
    routeResponseKey: SelectionKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponseRequest = {
    import CreateRouteResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponseRequest
      .builder()
      .apiId(__string.unwrap(apiId): java.lang.String)
      .optionallyWith(
        modelSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.modelSelectionExpression)
      .optionallyWith(
        responseModels.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween1And128.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.responseModels)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.responseParameters)
      .routeId(__string.unwrap(routeId): java.lang.String)
      .routeResponseKey(SelectionKey.unwrap(routeResponseKey): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewayv2.model.CreateRouteResponseRequest.ReadOnly =
    zio.aws.apigatewayv2.model.CreateRouteResponseRequest.wrap(buildAwsValue())
}
object CreateRouteResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateRouteResponseRequest =
      zio.aws.apigatewayv2.model.CreateRouteResponseRequest(
        apiId,
        modelSelectionExpression.map(value => value),
        responseModels.map(value => value),
        responseParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        routeId,
        routeResponseKey
      )
    def apiId: __string
    def modelSelectionExpression: Option[SelectionExpression]
    def responseModels: Option[Map[__string, StringWithLengthBetween1And128]]
    def responseParameters: Option[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ]
    def routeId: __string
    def routeResponseKey: SelectionKey
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getModelSelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "modelSelectionExpression",
        modelSelectionExpression
      )
    def getResponseModels
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And128]] =
      AwsError.unwrapOptionField("responseModels", responseModels)
    def getResponseParameters: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly
    ]] = AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getRouteId: ZIO[Any, Nothing, __string] = ZIO.succeed(routeId)
    def getRouteResponseKey: ZIO[Any, Nothing, SelectionKey] =
      ZIO.succeed(routeResponseKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponseRequest
  ) extends zio.aws.apigatewayv2.model.CreateRouteResponseRequest.ReadOnly {
    override val apiId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiId())
    override val modelSelectionExpression: Option[SelectionExpression] = scala
      .Option(impl.modelSelectionExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
      )
    override val responseModels
        : Option[Map[__string, StringWithLengthBetween1And128]] = scala
      .Option(impl.responseModels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.apigatewayv2.model.primitives
              .__string(key) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween1And128(value)
          })
          .toMap
      )
    override val responseParameters: Option[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ] = scala
      .Option(impl.responseParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.apigatewayv2.model.primitives.__string(
              key
            ) -> zio.aws.apigatewayv2.model.ParameterConstraints.wrap(value)
          })
          .toMap
      )
    override val routeId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.routeId())
    override val routeResponseKey: SelectionKey =
      zio.aws.apigatewayv2.model.primitives
        .SelectionKey(impl.routeResponseKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateRouteResponseRequest
  ): zio.aws.apigatewayv2.model.CreateRouteResponseRequest.ReadOnly =
    new Wrapper(impl)
}
