package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDeploymentsResponse(
    items: Option[Iterable[zio.aws.apigatewayv2.model.Deployment]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentsResponse = {
    import GetDeploymentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetDeploymentsResponse.ReadOnly =
    zio.aws.apigatewayv2.model.GetDeploymentsResponse.wrap(buildAwsValue())
}
object GetDeploymentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetDeploymentsResponse =
      zio.aws.apigatewayv2.model.GetDeploymentsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[List[zio.aws.apigatewayv2.model.Deployment.ReadOnly]]
    def nextToken: Option[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.apigatewayv2.model.Deployment.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentsResponse
  ) extends zio.aws.apigatewayv2.model.GetDeploymentsResponse.ReadOnly {
    override val items
        : Option[List[zio.aws.apigatewayv2.model.Deployment.ReadOnly]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.Deployment.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.apigatewayv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetDeploymentsResponse
  ): zio.aws.apigatewayv2.model.GetDeploymentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
