package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And128,
  SelectionKey,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateApiMappingResponse(
    apiId: Option[Id] = None,
    apiMappingId: Option[Id] = None,
    apiMappingKey: Option[SelectionKey] = None,
    stage: Option[StringWithLengthBetween1And128] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingResponse = {
    import CreateApiMappingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingResponse
      .builder()
      .optionallyWith(apiId.map(value => Id.unwrap(value): java.lang.String))(
        _.apiId
      )
      .optionallyWith(
        apiMappingId.map(value => Id.unwrap(value): java.lang.String)
      )(_.apiMappingId)
      .optionallyWith(
        apiMappingKey.map(value => SelectionKey.unwrap(value): java.lang.String)
      )(_.apiMappingKey)
      .optionallyWith(
        stage.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateApiMappingResponse.ReadOnly =
    zio.aws.apigatewayv2.model.CreateApiMappingResponse.wrap(buildAwsValue())
}
object CreateApiMappingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateApiMappingResponse =
      zio.aws.apigatewayv2.model.CreateApiMappingResponse(
        apiId.map(value => value),
        apiMappingId.map(value => value),
        apiMappingKey.map(value => value),
        stage.map(value => value)
      )
    def apiId: Option[Id]
    def apiMappingId: Option[Id]
    def apiMappingKey: Option[SelectionKey]
    def stage: Option[StringWithLengthBetween1And128]
    def getApiId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getApiMappingId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("apiMappingId", apiMappingId)
    def getApiMappingKey: ZIO[Any, AwsError, SelectionKey] =
      AwsError.unwrapOptionField("apiMappingKey", apiMappingKey)
    def getStage: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingResponse
  ) extends zio.aws.apigatewayv2.model.CreateApiMappingResponse.ReadOnly {
    override val apiId: Option[Id] = scala
      .Option(impl.apiId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val apiMappingId: Option[Id] = scala
      .Option(impl.apiMappingId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val apiMappingKey: Option[SelectionKey] = scala
      .Option(impl.apiMappingKey())
      .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
    override val stage: Option[StringWithLengthBetween1And128] = scala
      .Option(impl.stage())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And128(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateApiMappingResponse
  ): zio.aws.apigatewayv2.model.CreateApiMappingResponse.ReadOnly = new Wrapper(
    impl
  )
}
